Working Outside of the Practice
There are a number of reasons that a specialist may choose to work outside of his or her original practice. Many have a routine of traveling to work out of a local private practice every week. Some only make such a visit on a monthly basis. Still others make this their full-time pursuit by working as part of a dental team at a multi-specialty practice.
If you're giving some thought to expanding the application of your skills, there are a few factors you would do well to take into consideration.
Benefits to the Patients
A noble reason for working out of another office is to increase access-to-care for a wider range of people. Some specialty practitioners make special trips to under-served areas so that individuals who have a hard time reaching an endodontist or periodontist have a chance at getting the care they need.
Multi-specialty practices which provide a broad range of specialists make dental care much more convenient for the patients. This convenience makes it easier for entire families to get the varied care they need. A patient may be more compliant with referrals for special care when they are done "in-house," so to speak.
Another very important benefit to the patients is that key information will be more reliably transferred between dental professionals. A long-time patient of the general dentist can rest assured knowing that records can be relayed in person, avoiding dangerous confusion. This is also beneficial to the relationship you have with the dental team of the other practice.
Impact to Your Practice
Working with another dental professional who has an established reputation can lend a lot of credibility to your own name. Patients who meet you through the private practice for specialized care may be willing to follow you back to your practice for continued care, if needed in the future.
Don't neglect to consider how your absence might affect your existing practice. You may have the goal of leaving altogether to work full-time as part of a dental team, but even until that happens you need to make sure you are balanced in how and where you put your skills into application.
Effect on Your Life and Routine
Consider carefully how the extra travel could affect your life and routine. Is it reasonable to commute to another practice on a regular basis? If so, how frequently? Think about how dividing your attention and energy between multiple offices will affect your family and your ability to concentrate on each patient case.
Getting Started
Begin by reaching out to your network of colleagues who practice in your area. Consider locations that offer a population with enough of a demand to justify your services. Rural areas, for example, might only merit a monthly visit. A highly urban region, however, might need multiple specialists in the same field to be available to fill the need.
Ask general dentists about how many cases they see that could be referred to you. Design a trial session to see whether investing in another practice will be beneficial to the patients, the practice, and yourself.