4 Ways Mobile Technology Can Improve Care
By Kathleen Roney:
Mobile technology is popular. That in itself is not shocking. The adoption rate of mobile technology has been rapid. You can take one look around and see most people are using smart phones, iPads and tablets. Mobile technology is not new to healthcare either. Although it may not be as prevalent as it is commercially, many physicians and nurses use iPads and smart phones to aid hospital rounds, communicate and guide patients in treatment recommendations.
However, there are heated debates over the safety of mobile health. Data security and HIPAA compliance has yet to be tackled, evident in the onslaught of data breaches, and there are many conflicting reports on the clinical safety of mobile health technology. Some studies report that mobile technologies improve workflow and aid physician productivity, yet other studies report that iPads and smart phones are distracting and dangerous to patients.
While the safety of mobile health is questionable, there is no denying its market — and that of health applications — is huge. In 2011, the mobile health market reached $718 million in the United States alone. Harnessing the prevalence of mobile technology to meet CMS regulations and meaningful use requirements could greatly benefit the healthcare industry while not compromising medical professionals’ productivity or patient privacy.
Here Robert Oscar, registered pharmacist and CEO of RxEOB, a healthcare company that offers web technology, analytics and automated services, discusses four ways the growing mobile health market may benefit patients and providers.
1. Increase medication compliance. Mobile technology can help patients adhere to medication orders. It can tell patients why medical adherence, especially prescription adherence, is important by sending them messages and information. “While no one can guarantee patients will actually read or even absorb the information, allowing them access in an easy, convenient method is a start,” says Mr. Oscar.
Mobile technology can also calculate when a prescription should run out and then send the patient a reminder to get a refill. When the patient refills their medication, mobile technology can send dosage reminders such as “It is 7 a.m. Time to take your blood pressure medication.” Finally, mobile technology can ask the patient if they took their medication or not. “It works as a delayed reminder but it also provides a way to document whether the patient took their medication,” says Mr. Oscar.
These capabilities offer hospitals a method to lower medication noncompliance, one of the biggest factors in high hospital readmissions. A 2009 article published in the New England Journal of Medicine found that 17.6 percent of hospital admissions resulted in readmissions within 30 days of discharge, 11.5 percent within 15 days and 6.2 percent within 7 days. While variation in readmission rates varies by hospitals and geographic regions, reducing hospital readmissions could lower healthcare costs.
Additionally, the Patient Protection and Affordable Care Act, as amended by the Health Care and Education Reconciliation Act, includes a provision that is intended to reduce preventable hospital readmissions by reducing Medicare payments to certain hospitals with relatively high preventable readmission rates. Hospitals could leverage mobile technology to reduce readmissions, meet the new federal expectation, and avoid penalties.
2. Improve post-treatment understanding. Mobile technology gives patients, and hospitals, a convenient medium to monitor hospital discharge instructions and double check prescriptions. Medication accuracy, a huge patient safety issue, could improve as a result.
Patients receive a lot of paperwork and instructions when they are discharged from the hospital. The scenario is not conducive to patients remembering detailed treatment and prescription requirements. Mobile technology might help patients recall the information onslaught they receive at hospital discharge by sending post-treatment instruction reminders.
According to Mr. Oscar, a classic example of a medication mistake starts with a patient who takes generic Valium, diazepam. The patient tells the hospital intake nurse about this medication, and it is recorded. However, the patient is prescribed the brand name Valium while in the hospital. As the patient later leaves the hospital, a physician writes their prescription for Valium but the patient does not know it is the same thing as what they already have at home. “All of a sudden the patient could be taking a double dose of their prescription which could land them back in the hospital very quickly,” says Mr. Oscar.
3. Patient access to health information. Another advantage of mobile health is that apps can provide health information access to patients.
“Mobile technology can take health information where it is stored, and possibly inaccessible, and make it more accessible to patients,” says Mr. Oscar. “In a more transferrable format, health information can improve efficiency of the patient and physician interaction by informing both about past therapies and conditions.”
Thus, mobile technology addresses an element of CMS’ Stage 2 Meaningful Use requirements — providing patients with easier access to their health information. Eligible hospitals and healthcare professionals are encouraged to create patient-specific education resources and give patient’s access as well as enable patients to view online, download, and transmit their health information. Some providers are even required to communicate with patients electronically on relevant health information.
Mobile technologies can help hospitals and healthcare professionals realize these expectations by storing and monitoring a patient’s historical information. “If a physician can get historic information and apply it as a patient is treated, it is the first step in improving evidence-based practice standards,” says Mr. Oscar. “The key is making information that is already accumulated and stored about a patient including treatment and condition histories much more available to prescribing physicians and patients.
4. Aggregate data, improve population healthcare. According to Mr. Oscar, mobile technologies can give providers information on the newest and greatest evidence-based medical practices. Applications can be developed that track health outcomes to see where deviations from expected outcomes occurred and why, so healthcare professionals can work to fix them in the future.
“Medicine being an art as much of a science, there are lots of reasons, why given a patient’s circumstance, there would be a deviation from expected outcomes,” says Mr. Oscar. “Mobile applications help track and match deviations against published and accepted evidence-based medical practice standards. [Researchers and analysts] can then determine if a medical evidence-based practice can be improved.”
The tracking of health outcomes and deviations may improve the healthcare system’s ability to assess population health. Similarly, mobile applications could be used to track health trends as an early indicator of emerging health issues. The Department of Human & Health Services began a mobile app challenge in late March encouraging web developers to create a web-based application that uses Twitter to track health trends in real time. With mobile applications tracking health trends and outcomes, federal agencies and healthcare organizations could cross-reference data to build a baseline of trends and statistics to advise research and improved medical practice.
Mobile technology is a burgeoning area in healthcare. It has many great implications, some of which are just on the brink of being realized. Mobile technology may increase health information access for patients, improve medication compliance and treatment adherence and enhance population health and research capabilities.
Source: