Why bother with wellness in the workplace? Well firstly, morally, it’s the right thing to do. Equally important, wellbeing has a direct effect on productivity. And on a broader level, absenteeism and presenteesim is costing the UK economy as much as £77 billion every year.
There’s plenty of research out there to prove that wellness in the workplace pays. Healthy employees have more energy, are more motivated and stay focused for longer.
If you are serious about success, then you need to get serious about the wellbeing of your workforce. Here are 3 wellbeing initiatives you should be implementing.
1. Pay attention to posture
Few businesses pay enough attention to office ergonomics. But, posture in the workplace has a huge impact on productivity and absenteeism. According to the Office for National Statistics almost 31 million working days were lost in the UK in 2016 due to musculoskeletal problems, including low back pain.
Also read: Should You Consider Standing Desks? Benefits and Options for Healthier Employees
Both physical work and sedentary jobs can be harmful to the body. While safe practices for manual work are essential and most businesses seem to have this covered, the attention given to the harm caused by sitting for long periods is another matter. An alarming amount of businesses don’t invest properly in the right kind of equipment to support good posture. Neither do they actively encourage regular breaks from sitting.
Author Mike James spoke to ergonomics expert Nichola Adams at Corrigo Design, and she expressed concern over the timelag between rapid technology growth and increasingly sedentary working environments, and businesses providing proper education about posture at work. Her blog What is the hidden time bomb in your company? is well worth a read. It outlines the importance of occupational healthcare and offers tips on postural wellbeing.
Workers not only need appropriate chairs, desks and equipment, they also need to take regular breaks from sitting. This should be actively encouraged and become part of the office culture. Straighten Up UK is an exciting programme from The British Chiropractic Association designed to improve posture and prevent back pain.
2. Minimise stress
A certain amount of stress in the workplace is inevitable, but be aware that too much stress has an adverse effect on productivity. Stress also contributes to poor mental health. The Government’s Department of Health advises that one in four of us will experience mental ill health at some point in our lives.
According to the Advisory, Conciliation and Arbitration Service (ACAS), mental ill health costs the UK £30 billion every year through lost production, recruitment and absence. The Health and Safety Executive (HSE) report that 12.5 million working days lost due to work-related stress, depression or anxiety in 2016/17.
Also read: 5 Ways To Help Your Employees Manage Stress
In the workplace, stress constricts thinking. One work performance expert said stress means we make poor decisions, snap decisions, emotional decisions, and have an inability to see beyond the latest crisis. Mental health problems can lower productivity considerably.
Working smarter not harder is the answer. Encourage a working environment where multi-tasking is frowned upon. Focusing on fewer goals actually increases productivity and reduces stress. Don’t expect staff to improve in multiple areas. Allow them to work on developing one skill at a time.
Importantly, recognise the signs of stress in your employees so you can rectify the situation quickly. Stress has a negative impact on motivation, loyalty and the body’s immunity. Ignoring stressed employees will impact absenteeism and ultimately hurt your business.
The mental health charity, Mind, say that promoting wellbeing within the workplace can reap significant rewards in terms of productivity. Their free resource, Introduction to mentally healthy workplaces shows employers how.
3. Focus on food
Good nutrition is essential for good health. It’s no surprise that what you eat affects your productivity. Provide healthy snacks, a fruit bowl and organise regular team lunches with healthy offerings. Your focus can even extend to educating your employees about the benefits of healthy eating. The British Heart Foundation offer free resources for healthy eating workshops you can run for your employees.
Also read: Encourage Healthy Breakfasts To Fuel Work Productivity
Diet has a profound effect on weight, your sense of wellbeing and even affects the risk factors for certain diseases. It makes perfect sense for employers to encourage healthy eating at work.
Water coolers are a good idea. Remind employees of the importance of keeping hydrated. Drinking water improves brain function, including thought and memory processes. Also, offer herbal teas. Too much caffeine can lead to jitteriness and anxiety, which will ultimately distract your employees from their work.
Eating mindfully is just as important as what we eat. Encourage employees to eat lunch away from their desk.
Wellbeing at work shouldn’t be an after-thought, it should be an integral part of your business strategy. Put your people on the balance sheet and look after them and they will boost productivity and look after your business.
Image licensed from Depositphotos.com