BUSINESS RULES
by Bruce Silver
Major IT initiatives may be a tough sell in this economy, but many
organizations are investing in order to meet government mandates and
competitive threats. The Health Insurance Portability and Accountability
Act and UCCnet are two examples of market forces driving adoption of new technology.
Surrounded by the rubble of the New Economy meltdown, advocates of e-business
transformation have increasingly seen the life snuffed out of their once "mission-critical"
projects by the CFO's new litmus test: Can you guarantee me return on investment in twelve
to eighteen months?
The age-old technology promises of faster, better and cheaper ring hollow in today's
world of fear, uncertainty and doubt. No one disputes that replacing paper documents with
electronic data, manual processes with automation, or proprietary formats and protocols
with open Internet standards will probably eventually lower costs, increase agility and
even improve service to customers, but today, who can afford to think about the eventual
or even the probable? IT investment now requires immediacy and certainty of result, not
crossing a no-man's-land of competing half-baked technology standards or relying on
high-tech partners who could be in Chapter 11if not in jailany day now.
Still, e-business is succeeding, in isolated pockets, propelled over the CFO's hurdle
either by government mandates or the progress of direct competitors. Now that the go-go
days are gone, these two Old Economy pressures, one coming from government and the other
from the free market, are defining the new e-business landscape.
A good example of a government mandate is HIPAA, the Health Insurance Portability and
Accountability Act, passed in 1996 during the upswing of the internet revolution but just
now finalizing its regulatory requirements. HIPAA represents a revolutionary standardization
of medical informationhow it is encoded and transmitted electronically, how it is secured
and how its privacy is maintaineda massive IT investment affecting all insurers, hospitals,
physicians, even pharmacies and labs.
While reduced administrative costs are the carrot, the investment driver is really the stick.
Once the regulations are finalized, most health plans and providers must comply within two years
or face stiff fines. That clock is about to start.
The healthcare industry, cash-strapped even back in bubble days, has seized upon the compliance
mandate to justify a wholesale IT upgrade. A survey of large hospitals early this year found
that nearly 70 percent of them are using HIPAA compliance as the hook for introducing new
computer technology and best practices hospitalwide.
Mandates can be shaped by industry itself. An example from the Securities Industry Association
is called T+1, referring to the settlement of securities trades within one day of the actual trading
date instead of the current three days. T+1 is really just one objective of a broader movement called
straight-through processing (STP), automation of front- and back-office business processes cutting
across company lines in many segments of financial services.
In pre-recessionary times, T+1 promised to increase trading volumes while reducing credit risk,
and the way was paved for mandated compliance (backed by SEC regulation) by 2005. Now, however, to
most securities firms the cost seems to outweigh the benefits. In July, the SIA decided to put T+1
aside for now and re-evaluate in two years, while encouraging work on other, more narrowly focused
STP initiatives.
A very different kind of pressure for e-business transformation is simply incremental adoption
of new systems and standards by key competitors. An example of that is UCCnet, a
not-for-profit-sponsored service offering data synchronization and a global registry of product
information for retailers and their consumer packaged goods suppliers. Without UCCnet, a simple
can of Campbell's soup has a different product name, description, pricing and promotion data in
the database of every supermarket chain that sells it. That means manual data entry to patch over
the differences whenever new information comes out from the supplier. By acting as a middleman,
UCCnet claims it can "increase quality purchase orders by 30 percent, increase speed-to-shelf for
price changes and new products by 80 percent, and raise point of sale scanning accuracy to 99.8
percent."
That's the old hookfaster, better, cheaperbut with real industry adoption. Two original
pilot partners, Ralston Purina and Wegmans Food Markets, converted to UCCnet after the pilot. Kraft
Foods and Shaw's Supermarkets started using it as well, as did giant chains Ahold USA and Wal-Mart.
The tipping point is when other companies fear being left behind by their competitors. It's a
different kind of stimulus than a mandatemore speculative in the beginning, more certain in
the end.
It's not surprising that suppliers of business process management, content management, and
related platform technologies are now offering specific solutions for HIPAA, STP and UCCnet
in their search for ready-to-buy customers. These scattered initiatives seem to be the model
for the new New Economynot radical new business models, but industry-wide adoption
of new systems and standards by established companies. Sometimes mandates are required,
sometimes adoption flows incrementally out of pilots that work.
It's a conservative plan for a conservative time. |