Not all relative falls in sea level occur at a fast enough rate to
expose the continental shelf. For example, during a eustatic fall, a
rapidly subsiding margin may still experience a relative rise in sealevel,
provided the rate of eustatic fall is less than the rate of subsidence.
Early seismic studies recognized two types of sequences reflecting the
case of sea-level fall below the shelf-slope break (type 1) and the case
where sea level does not fall below this break (type 2). Although there
has been much subsequent confusion about the application of these two
types to outcrop studies, their definitions have been modified such that a
type 1 sequence now refers to one in which there is a relative fall in sea
level below the position of the present shoreline and a type 2 sequence
refers to a sequence in which the relative fall in sea level does not
force a shift in the position of the shoreline. Type 1 sequences were
discussed above in the preceeding sections; type 2 sequences are discussed
below.
Type 2 sequences (shown below) are similar to type 1 sequences (shown
above) in nearly all regards except for the extent of the
sequence-bounding unconformity and its expression in the marine realm. In
addition, the two sequences differ in the name of the systems tract lying
above the sequence boundary but below the transgressive surface .
In a type 2 sequence, the extent of the sequence-bounding unconformity
can reach seaward only to the position of the previous shoreline, but no
further. In other words, none of the marine areas of the previous
highstand are subaerially exposed during a type 2 sequence boundary. Updip
of these areas, the sequence bounding unconformity is expressed as for a
type 1 sequence, but no incised valley forms as sealevel does not fall far
enough for incision. In the marine realm, no basinward shift of facies
occurs as in a type 1 sequence, and the type 2 sequence boundary is
characterized only by a slight change in stacking patterns from
increasingly progradational in the underlying highstand to decreasingly
progradational (possibly aggradational) above the sequence boundary.
Detecting this subtle transition in marine sections may be difficult to
impossible and many type 2 sequence boundaries probably go undetected.
The shelf margin systems tract in a type 2 sequence is equivalent in
stratigraphic position to the lowstand systems tract of a type 1 sequence.
As stated above, the shelf margin systems tract is characterized by
aggradational stacking. Like the lowstand systems tract, the shelf margin
systems tract is capped by the transgressive surface.
In general, far more type 1 sequences have been reported than type 2
sequences, possibly in part reflecting their comparative difficulty or
ease of detection. Some workers have gone so far as to question the
existence of any type 2 sequences.