A New Kind of Bomb Is Being Used in Syria and It's a Humanitarian Nightmare
Syrian government jets struck a market in Douma, a suburb northeast of Damascus, on August 16, killing almost 100 people. Some reports attribute the lethal strike to a volumetric weapon, also known as a vacuum bomb.
In his condemnation of the attack, Staffan de Mistura, the UN special envoy for Syria, alluded to the possibility that the Syrian air force used a vacuum bomb, saying that "[a]ttacks on civilian areas with aerial indiscriminate bombs, such as vacuum bombs, are prohibited under international law."
However, researchers and human rights advocates, observing from a distance, are unable to confirm or properly investigate whether this is the case.
"We suspect they may have been used," Mary Wareham, the advocacy director of Human Rights Watch's Arms Division, told VICE News.
In conflicts like Syria, investigators and human rights groups face an uphill battle in making determinations about the particulars of such an attack. Lacking solid video evidence and unable to access the blast site, investigators have little to go on. These obstructions to research and investigative capability leave clear information on the use of volumetric weapons in Syria out of reach..
The shockwave produced by volumetric weapons lasts longer than the blast of conventional high explosives; a little like the difference between a bellowing explosion and a sharp bang. Conventional high explosives typically explode and create most of their effect by propelling shrapnel out in a cloud of deadly high-speed projectiles, or from the short, sharp blast. By contrast, volumetric weapons generate effects through heat and extreme pressure over relatively long periods of time, and are very effective against certain kinds of soft targets, such as minefields and aircraft parked in the open.
Alternately, volumetric weapons work well against certain kinds of concealed targets, such as those hiding in caves or bunkers; the twists and turns of the tunnel or building would normally protect people from flying shrapnel, but the cloud of explosive can penetrate some distance before detonating, while the walls themselves channel and focus the blast.
A Human Rights Watch background report on volumetric weapons used by Russia in 2000 describes the weaponry as "prone to indiscriminate use" and likely to cause high rates of civilian casualty when deployed in urban environments.
"The fuel-air explosive is just another way of killing people in ways that leave bodies that are horrifying to look at," Dr. Theodore Postol, MIT physicist and missile expert, told VICE News. "So it increases the terror in regard to these attacks on innocent civilians."
Like barrel bombs or sarin gas, the point of using vacuum bombs goes beyond the destruction of city blocks and the unfortunate civilian inhabitants. The ultimate purpose of such weaponry is to terrify, to sow fear amid chaos.
Watch VICE News's Jihadists vs. the Assad Regime: Syria's Rebel Advance:
Mark Hiznay, a senior researcher at Human Rights Watch's Arms Division, points to two types of injury that are primary indicators of a possible volumetric weapon: terrible burns on victims closest to the blast and high rates of crushing injuries.
Because volumetric weapons diffuse the explosive in a cloud before igniting, they consume huge amounts of atmospheric oxygen as they detonate. While they won't suck the oxygen out of the air at a distance, the local effect is pronounced enough to create a partial vacuum in an enclosed space, such as a bunker, basement or apartment, killing occupants that might otherwise be safe from the blast.
They "bring down buildings and lungs alike," Perkins notes. Beyond the characteristics of harm inflicted on humans, the bombs are also characterized by the absence of large blast craters that accompany typical explosives of similar size.
The deadly qualities of these munitions, with their ability to create widespread destruction and civilian death, may offer significant appeal to those who can gain access to them. Volumetric weapons were deployed, to international condemnation, by Russia in Chechnya in the late 1990s and early 2000s. And they seem to be making a comeback. Thermobaric and FAE weapons have surfaced in the current conflict in Ukraine, and the TOS-1 rocket launcher, first implemented by Russia in Afghanistan in 1989, appeared in Iraq last year.
A full understanding of Syria's use of such weapons is stymied by the need for specialist knowledge for proper determination. Those on the ground witnessing the chaos of aerial bombardment often lean on terms like "vacuum bomb" to convey a sense of destructive scale.
"It's a bit similar to how sometimes people call them barrel bombs," Perkins said. "People on the ground often are just using a term that they think will capture the scale of what they've seen happening."
Syrian President Bashar al-Assad's forces have used volumetric weapons before, in scattered instances both certain and unconfirmed.
In 2012, a government strike in Azaz that killed more than 40 civilians was strongly linked by Action on Armed Violence to an ODAB-500 PM, a 500kg fuel-air explosive bomb of Russian origin. On September 29, 2013, a volumetric weapon was dropped on the Ibn Tufail Commercial Secondary School in Raqqa, killing 14 people, 12 of whom were schoolchildren. The trauma suffered by the dead — flash burns and injuries from being thrown against a wall by a blast wave — suggested a volumetric weapon.
It is unclear at what point Syria might have acquired its stocks of ODAB bombs, or how many they still have available. This is yet another limitation on the international community's ability to track the conflict and another long-term frustration for those monitoring the government's actions.
The ability of investigators and human rights advocates to monitor (or even diminish the use of weapons likely to result in high numbers of civilian deaths) is going to rely on the capacity to track their implementation and effect. But evidence of the increased use of volumetric weapons has so far proven difficult to monitor, and the demands on the forensics involved mean that few incidents can be confirmed with any real certainty. Researchers and rights groups, therefore, have few opportunities to publicly challenge their implementation in certain environments as unethical.
Volumetric weapons may turn out to be the closest thing the fighting in Syria has to a mascot: utterly savage, wildly indiscriminate, and able to suck the moral clarity out of tragedy.
Follow Torie Rose DeGhett on Twitter: @trdeghett