The social missions of cryptos
The initial focus of ESG compatibility with digital assets has been on the E - environmental component, described in our article Are Cryptos Going Green?, but with time, the S - the social component is taking up. Digital assets now seem to be the keystone of more equality and more inclusion all over the world.
Financial inclusion is key to reducing poverty, hunger and gender inequality. It also helps foster education, entrepreneurship and well-being as mentioned in the report by Cogent Social Sciences.
The latest World Bank Global Findex report (2017) estimates that 1.7 billion people don’t have a bank account, although two third of those unbanked already own a smartphone and use social media. There is growing interest in digital assets in regions where the local population has limited access to banking facilities.
Cryptocurrency adoption in emerging countries has skyrocketed. According to the Global Crypto Adoption Index by Chainalysis, only one developed country (USA) is within the top 20 adopters in 2021, all others are developing countries.
Today, in Africa, crypto transfers made up for 7% of retail-size transactions while the global average is 5.5%. (source: Chainalysis, Business Insider)
Why are cash-based economies adopting cryptos so rapidly?
Store of value
The main reason is protection against inflation as residents in low-income countries face frequent currency devaluations. Buying cryptocurrency, despite the high volatility, is a way to preserve their buying power. People struggling with inflation would turn to digital assets for purchasing and selling goods either locally or internationally. Also, cryptos are safer and easier to store than cash. While, in many of those regions, economies are still largely cash-driven, crypto users won’t need to drive to the bank, they just need an internet connection.
There is also a case for migrants to adopt digital assets to avoid having their cash stolen by smugglers and thieves on their way to richer and peaceful countries. While traveling, digital assets are easier to protect than cash.
Cheap and unlimited remittance
Overseas remittances are a crucial part of the economy for many emerging and frontier countries, especially in areas where populations have massively migrated internationally. In 2019, about 25 million expats of Sub-Saharan African countries, remitted $48 billion in traditional currencies back to their home land, sometimes paying up to 15% fees (source: World Bank). Remittance is expensive in traditional money while it is free or at a low cost in digital assets.
Cryptocurrencies are also a new way to deal with individual remittances in countries where the legal tender is not (or partially) convertible. Some governments limit cross-border transactions or ban some foreign currency (ie. Cuba banning the USD). Sending or receiving cryptocurrency gives a way to circumvent those limits so that the residents can meet their financial needs. As a consequence, remittance of digital assets has grown tremendously over the past few years.
On a broader spectrum, Decentralised Finance is empowering users to access finance apps with a much lower access threshold, to cover remittance, lending, trading and any other finance services.
Gender equality
According to the Findex report, 56% of all unbanked adults are women and the gender gap is even wider in developing economies, where 67% of men have a bank account, against 58% of women. In some countries, women can’t open an account without the approval of their husband/father. In Afghanistan now, women can’t even go to work as they need to stay at home. With the right education, women can now work from home and be paid directly into their own digital wallets. For a real case study, you can read the article ‘Finding Financial Freedom in Afghanistan’ by Alex Gladstein (Bitcoin Magazine).
Certain regions give more inheritance rights to men than to women, some parents may therefore open a digital asset wallet to transfer some funds to their daughters.
Workforce around the globe
Can cryptos help find a job? Blockchain and cryptocurrencies have definitely created new ways to earn a living with mining, staking or lending assets. Those new jobs could be done from home wherever this is. While bitcoin mining would require high computing power, staking and lending only require a standard internet connection with no particular equipment. As a result, cryptos help slow down migration for economic reasons. On top of crypto specific jobs, remote working was already standard for call centers and IT development, digital assets are bringing virtual workspace to another level. Some workers now looking for traditional jobs to be paid in cryptos, either full-time or part-time (ie. Laborx, Pompcryptojobs).
You can also start your own business and get paid in bitcoin from anywhere in the world without a bank account. Through Decentralised Finance (DeFi), the crypto ecosystem lowers the barriers to access to finance: anyone can create finance applications and interact directly with the smart contracts from their crypto wallets.
Being paid in digital assets gives potentially high returns in value, enhancing living standards in case the crypto has performed well. To avoid being impacted by volatility, the worker might convert some earnings into stablecoins.
Cryptos as a tool for human rights
Political and economic crises are fertile grounds for Bitcoin to become a tool for human rights. In some countries, showing support to opponents of current regimes may end up with arrests and frozen bank accounts. Some protesters and dissidents around the globe are turning to bitcoin and other digital assets to secure their savings as decentralised assets are uncensorable.
Taking donations in bitcoin for human rights keeps the anonymity of the donors, who might be afraid of repression from authorities.
Bitcoin was invented after the 2008 financial crisis sent to bankruptcy some of the largest banks in the world. The programmed currency directly addresses issues of poor governance of traditional currencies, with the belief that the blockchain technology is more trustworthy than institutions. The formidable development of digital assets in areas where institutions failed their population, shows that digital assets are a social tool working for more equality in the world.
Website
Twitter
Join our community
Telegram
Discord