Pneumatic and hydraulic technicians in high demand worldwide are fortunate enough to work on some of the most interesting projects, from tunnel-boring under the English Channel to the diamond mines of South Africa, to fishing and seafood processing on Kodiak Island, Alaska.
That said, this industry now faces a crisis concerning the operator’s skill level, which varies from slim to almost none, according to Rory McLaren, founder of the Fluid Power Safety Institute. He believes hydraulic maintenance workers can benefit from labels, which would put the rules, instructions, warnings, and other critical training tips right in their faces.
“The maintenance industry is in poor shape,” he says. “Ninety percent of the people working on hydraulics have no training at all. It’s an occupational free-for-all.”
Stay on schedule
Given the nature of these multimillion-dollar projects, it’s more cost-effective to perform scheduled maintenance and service on hydraulics and pneumatics rather than make repairs once these projects are underway.
“Just like getting blood drawn at the doctor, proper oil sampling is the key to determining the condition of internal hydraulic components,” says Ben Opp, inside sales representative at Pirtek Chicago, a mobile hydraulic service. “With today’s ever-increasing working pressures and ever-decreasing operating tolerances, factory-installed, full-flow filtration is simply not sufficient to catch the majority of the particles that actually wear down your components.”
Opp also says that to remove the 3- to 13-µm liquid sandpaper contaminants, which are always present in hydraulic systems, requires additional “kidney loop” filtration.
According to Brendan Casey, author of Insider Secrets to Hydraulics (insidersecretstohydraulics.com), more than 70% of spare parts sold for hydraulic equipment are used to replace defective components. And improper operation or maintenance causes 90% of these defects. Considering the high expense of these components, statistics suggest that inadequate or nonexistent maintenance practices cost hydraulic equipment users billions of dollars every year.
Smart labeling practices
McLaren suggests specific examples of effective hydraulic maintenance labeling:
- Safety warnings could be made for specific, limited situations. Many companies leave themselves susceptible to substantial jury awards because they ignore something as simple as a warning decal. This is typically referred to as “failure to warn.”
- Critical operating parameters should be posted on every hydraulic system.
- Post normal operating parameters on all machinery; therefore, operators can detect abnormal variations during the machine’s operation.
- Information such as operating temperatures, temperature drops across heat exchangers, pump and motor case pressures, pump inlet restriction, operating pressures, pump flows, hydraulic motor displacement, and accumulator pre-charge pressures should be posted in a way that’s easily accessible for mechanics.
Spelling out every-day working hazards aids both trained and untrained workers. McLaren likes to see signs that say:
- “To be serviced and repaired by trained authorized personnel only.”
- “Do not crack connectors to de-energize a hydraulic system. Discharging hydraulic oil to atmosphere can lead to severe injury, severe eye injury or blindness, substantial property damage, or death.”
- “Disconnect the battery and de-energize the hydraulic system before performing services, adjustments, or repairs.”
- “Do not test components by discharging oil into atmosphere. Discharging oil to atmosphere can cause severe injury, death, or substantial property damage.”
- “The hydraulic oil in this system is hot enough to cause second- and third-degree burns. Do not loosen connectors until the oil temperature is below 80°F.”
It’s counterproductive to bury important machine operating parameters in some manual no one reads, so posting machine operating parameters at the user’s fingertips is essential to communications. Manufacturers can help technicians, too, by posting normal and abnormal component leakage rates on their machines.
Label specifics
Such posted material does not consist of one- or two-word generic messages that can be found in sign or label catalogs. As a result, industry leaders such as Eaton Hydraulics and Chicago Pneumatic rely on DuraLabel systems to create and control content posted on signs and labels. They must be oil- and chemical-resistant, UV-resistant, and perform in environments with temperatures ranging from -40° to 302°F.
“Special attention needs to be given to color-coding and font clarity on labels,” says Jeffrey Ruth, an industrial product manager for HYDAC, a provider of hydraulic products and accessories to utilities, pulp, and paper mills and the pharmaceutical industry. “Critical procedure labeling is crucial to help plant personnel sequence their activities when completing dangerous tasks in safe and reliable ways. Also, warnings and notification labels help workers complete their jobs with fewer accidents and personal injuries.”
Plant managers can boost productivity and reduce downtime through proper preventive maintenance of hydraulic products and services, while increasing the sophistication and practicality of training. New technologies as well as tried-and-true preventive maintenance solutions include condition monitoring of the working fluid, monitoring of axial piston leakage flows, and automatic lubrication of moving parts and bearings.
Jack Rubinger, is with Graphic Products Inc., which manufactures DuraLabel sign and label printers, for the industrial workplace. For more information, visit, email jarubinger@graphicproducts.com, or call (800) 788-5572, extension 3024.