"Terrestrial Things: War, Language, and Value in Afghanistan" by Fatima Mojaddedi
Fatima Mojaddedi
Deposited 2016
Abstract
This dissertation is an ethnographic engagement with the social and political space of Afghanistan and how it has been shaped by the intensities of warfare in the last decade, with a focus on the realms of language, representation and economy. Taking Kabul as the panoramic ground of profound social and epistemological transformations, the dissertation traces a crucial shift beginning in 2011-2012, from a highly speculative war economy (a “green zone economy” that privileged the commodification of language and culture and the privatization of war, with crisis as an alibi for governmentality) to one based on equally speculative practices of prospecting for natural resources in the Afghan underground: where an estimated three trillion dollars’ worth of copper, gold, iron-ore, marble and oil & gas is presumed to lie in wait.
I illustrate the nuanced epistemological concerns and political contestations that stem from an Afghan effort to distinguish between sources of violence and sources of economic value (especially in the aftermath of Kabul’s demilitarization) in a milieu where foreign militaries presuppose that civilians and insurgents cannot be distinguished, except through the medium of war-time translation and collaboration.
The twin concern with generalized forms of death dealing and tragedy, on one hand, and the moral and political exigency for Afghans to distinguish between a world of appearances and one of essences (the Islamic and Quranic interpretation of zahir (exterior/surface) and batin (interior/ground), on the other, opens onto a set of epistemological concerns undergirded by several oppositions, which I argue, are central to American war making. I illustrate that the movement between these artificial binaries (Persian/Pashto and English, literacy and illiteracy, rationality and irrationality, repetition and transformation) inspires aspirational fantasy on an economic frontier and invests some Afghans (especially those who speak English and are literate) with the power of calculative reason (aql) and understanding (fahm and dânish), while condemning those who are illiterate (and sometimes those who only speak Persian and/or Pashto) to forms physical supplementarity and crisis--from literally being expendable prosthetic bodies (human body armor) to the breakdown of meaning in incestuous relations and the intensification of moral crisis.
In this context, conventional writing and the felt lack of its absence illustrate for us the logic of war in more consequential ways. The belief that writing is the domain of what can be known (rationally understood) and universally applied invigorates the ideology of literate persons and war-time collaborators with shocking breadth and tenacity. It organizes antagonisms between persons and structures forms of death-dealing.
I trace how the production of a binary around literacy and illiteracy produces, even in moments of technological acquisition, the retrospective fantasy that orality is not only the prior but also the locus of unfettered subversion and ignorance of the law. This misrecognition of linguistic diversity as lack comes to inform, in contexts of unprecedented transnational war-time activity, the charge that Afghans are beholden to an excessive localism that fuels the predicaments of the Afghan State and errors of judgement (such as incestuous transgressions, and suicide bombing) which would destroy society altogether. The issue of vulnerability to ideological suasion and excess emerges alongside these presuppositions. It informs the belief that the incapacity to exercise reason (due to illiteracy) renders Afghans vulnerable to diverse forms of propaganda and the inability to distinguish between the world of appearances (both technological media images and the Islamic notion of the zahir (surface manifestation)) and reality.
I trace these complexities through a series of intense contact points where these oppositions come into play and determine forms of access and violence 1) in translational contexts during combat missions where linguistic transformation results in deadly misunderstanding 2) in familial contexts and contestations over property, where the failure of interpersonal and extrajudicial mediation results in mass murder 3) in courtrooms where failed suicide bombers (who did not detonate out of technological error or because they were attacked by members of the Afghan National Police) are subject to the limitations of oral testimony and to the belief that photographic evidence proves that they will repeat their crimes if released from prison 4) instances of incest that arise out of illiteracy and, when exposed, generate moral crisis 5) the production of zones of exteriority and interiority (especially in Kabul’s Green Zone) that rely on phamakological inclusion and reproduce the literal supplementarity of Afghan bodies 6) the attempt to find the “real” sources of economic value as part of a multi-national gold and mineral extraction endeavor—the continuation of an obsession with the Afghan ground that has a long imperial history from the 1800’s onwards (when it was assessed through botanical, railway and coal prospecting missions).
Together, these sites and the consideration of the earthen terrain alongside the terrain of rationality and linguistic difference situate us in the midst of wartime catastrophe. They foreground the fantasy that rationalism is the sine qua non of modernism, and the belief that literacy is the basis for reflective and intellectual thought, and for being human. But what they also disclose for us is that in its absence you can (and sometimes must) die.