Write code to test code
One of the job descriptions for my work these days is that “I write code to test code”. And this sounds so familiar.
In a recent book “How Google tests software”, it is discussed in detail so as in what different ways Google engineers perform testing. The book is detailed and filled with practical experiences and it is not possible to explain the concept in this little window. But one thing is sure: almost every engineer there writes code to test code. Excerpts from Chapter 1 about the three dominant roles in engineering terms:
“SWEs (software engineers) write a lot of test code, including test-driven design (TDD), unit tests, …”
“SETs (software engineer in test) also spend close to 100 percent of their time writing code, but they do so in service of quality rather than coding features a customer might use.”
“Some Google TEs (test engineers) spend a good deal of their time writing code in the form of automation scripts and code that drives usage scenarios and even mimics the user.”
If I depict this picture as above where the numbered circles represent some engineer in a team, and that engineer may be totally focused on programming or testing activities, or it may have a mix.
The example from Google above means that they live by numbers 3, 5 & 4. (home work: relate these numbers with the roles mentioned above)
Some teams are against the idea of dedicated testers and they live by number 1, 3 & 5.
Some people are against the idea of “testers writing code”, they live by the number 1 & 2. But beware as more and more testing jobs need programming skills.
What are the numbers being used in your team? And how you think “write code to test code” is changing the numbers?
11 responses to “Write code to test code”
Trackbacks / Pingbacks
- September 30, 2013-
- July 8, 2014-
- October 21, 2014-
- January 14, 2015-
Development Team writes code and Testing Team verifies code written by developers by writing their own code but who verifies the tester code?
Are they always sure that the code written by testers are 100% correct?
I have my own experience in this regard but I would like some testers to comment on this.
Thanks for your opinion and you are spot on Akif. It is one of the paradoxes of software testing also known as ‘Who watches the watchman’.
The code that testers write can also have bugs and when our tests start failing, it can be a problem with our test code or it can be a problem with production code as well. So these kind of issues come along as you know every thing in life is like a ‘package’ and not all good.
There are reasons though, where tester’s code have less issues. 1) Testers are usually more conscious about quality 2) this layer is thin and 3) usually they follow a peer review mechanism. But still, ‘no code is bug free’ :)
Writing code to test code works most of the time if you are prepared to accept that the likelihood of both developer and tester making a mistake at the same place will be close to zero. If either or both make non-overlapping mistakes a defect is sure to be found which can then be investigated. Of course if both make a mistake in the same place as a result of interpreting the specifications then you could raise a defect against the documentation on the basis that clarification is required; of course you have to detect the fault first!
Thanks Ali for reinforcement. You are right that if two thinking heads look to test the same stuff, chances of quality work are more.
This makes sense to me but still there are minimal chances of defects being left. As there is nothing called bug free software (please correct if I am wrong) so we can live with that and on the identification it can be fixed in the next iteration.
Even though I have read, heard and experienced a lot on this issue, but as a test engineer my thoughts are still divided on the “Google-Way” of doing it. At one hand, I don;t want to let my test skills getting over shadowed by writing code in order to test a code. On the other hand, I don;t want test automation engineers to be the sole owner of automated test suites, and would prefer being on-board with the automation efforts. Writing test code is similar to writing piles and piles of documents to test an application;s functionality. Writing Test Specs and some 50+ pages of functional tests can probably make you a good documentation engineer, but test skills eventually start suffering and your documentation related issues get more focus than your test related issues (which should be your priority anyway). In either case, I am convinced that there has to be a balance. Yes, testers should be able to write code and document if needed, but this should not be their full-time focus.
I was waiting for your such comments Huma :)
You are absolutely right in mentioning the importance of ‘testing skills’ and that’s why we are not abandoning specialized testers. So what we want is that programmer try to learn some of these and hence step into Testing space. Similarly the proposal is that tester try to learn some of the programming skills and touch the Programming space.
Also agreed to your point of excessive test documentation time and I have some stuff ready on it. May be I should write a post dedicated on this topic of ‘less documentation and more work’.