Most successful salespeople and marketers use the “rule of reciprocity” when working with their customers. This time-honored tenet simply means that customers will return favors they have received. One should not think of this rule as a method of manipulating customers, but more as applying the “golden rule”. That means to treat customer as you would want to be treated.
In the graphic communications industry, we commonly see suppliers and print providers shower their top customers with trips to headquarters, customer events, business development resources and business insights. The “rule of reciprocity” draws on a powerful human tendency for customers to respond to a perceived gift from a supplier. There has been ample research in many areas of human interaction that confirms this process.
In his popular book, Influence: The Psychology of Persuasion, Dr. Robert B. Cialdini shares research and information that describes the power that reciprocation has on impacting customer behavior. It explains why so many great salespeople and companies expend time and money to provide offers and added value to customers.
For the best results, salespeople must be more than courteous, generous and kind. It requires a deep knowledge of the customer’s needs and wants, followed by a response.
Successful Marketers and Salespeople Use The “Rule of Reciprocity”
Some large suppliers within our industry have been successful in creating a sense of obligation with customers by providing first-class venues where products and services are demonstrated or presented. This has helped establish long-term loyalty. And for individual salespeople and small businesses with limited marketing budgets, very small actions and favors can have the same large impact on sales performance. Though lavish lunches and high cost events have lost favor with most buyers, there are some much less costly ways to provide “valuable gifts” to customers.
Here are ten examples of how printing salespeople can influence customers using the “rule of reciprocity”.
1. Apply the “Golden Rule”
Simply treating every customer as you would want to be treated pays dividends. Being on time, living up to commitments, taking accountability for problems and following up are becoming increasingly rare. The simple act of treating your customer with respect can be a low cost differentiator from your competition.
2. Create first class customer knowledge events
A great way to gain loyalty is by offering timely and impactful customer events. Every company should provide at least one event a year. There is no better way for customers to learn about new products, services and applications. Spending entertainment money wisely, along with providing valuable information for customers, will gain a disproportionately high return.
3. Help with business development
Getting inside and helping build profitable applications provides a huge value to customers. Not only are customers appreciative of the support, they will repay the salesperson with more business.
4. Give a gift
Providing small and relevant gifts is often well appreciated. Gifts such as business books and company promotional items are still welcomed by customers. A thoughtful gift will be remembered.
5. Give them content
Providing relevant case studies, research and examples of high impact business successes helps customers reach their goals. For time- starved customers, receiving relevant and timely content is well appreciated.
6. Get personal
Taking the time to know and show interest in a customer’s career objectives, personal challenges and interests is useful in developing a productive business relationship. For instance, participating in a customer’s favorite charity event can be a great way to gain loyalty.
7. Provide useful insights
Time is precious. Customers appreciate salespeople who can make them more successful by providing high impact recommendations and suggestions on how they can improve their business. A salesperson who knows their customer’s business is invaluable.
8. Give free education
Millennials love educational opportunities. Offers to teach customers about substrates, color, winning applications, file management and cross media workflows are a few knowledge areas that print providers can offer.
9. Take them out to the ball game
Knowing what is important to customers and accompanying them to sports events, concerts and restaurants is still a great vehicle to share business knowledge and build business relationships.
10. Stay current
Sharing the latest in technology trends and applications is an important “gift” that salespeople can provide. With all the changes taking place in business, no customer can stay on top of what is going on without some help.
Applying the “rule of reciprocity” in all customer interactions is a powerful business approach that provides a huge ROI in time and money. Do not treat the “the rule of reciprocity” as a one-time event. Like many other things in selling, many customers have short memories… keep on giving. If done sincerely with the customer’s best interest in mind, it is very difficult for any customer to