Backgrounder
Article from
Technical information about the Canadian ePassport
This document provides technical details about international interoperability, authenticity of origin, integrity, unauthorized reading and chip cloning.
Technical details about the chip
The ePassport contains an embedded contactless computer chip and antenna using radio frequency identification (RFID) technology with a frequency of 13.56 MHz. To read the information on the chip, the ePassport reader energizes the chip circuitry by wirelessly emanating power and communicating through its antenna. The designed operating range of the chip circuitry is very small; it must be held within 10 centimetres of the reader.
Interoperability: Compliance with international standards
With technology such as ePassport chips, it is important to make sure that the chip can be read in Canada and by other countries. To do so, the ePassport chip is rigorously tested to ensure it conforms to various internationally recognized standards, including:
- ICAO 9303: This is the International Civil Aviation Organization (ICAO) technical standard for machine-readable passports, specifically for biometric or electronic passports.
- ISO/IEC 14443: Managed jointly by the International Organization for Standardization (ISO) and the International Electro-technical Commission (IEC), this standard defines proximity cards used for identification and the transmission protocols for communicating with them.
- ISO/IEC 7816: Managed jointly by ISO and IEC, this standard is related to electronic identification cards with contacts, especially smart cards.
- Common criteria: This refers to the common criteria standard for information technology security evaluation.
Tampering and inauthenticity: Passive authentication
The ePassport bearer’s personal information and digitized picture are stored on the embedded chip. To prove this data hasn’t been tampered with and is authentic, a security feature called passive authentication is used. During production, the data is digitally signed with strong Public Key Infrastructure (PKI) algorithms such as RSA-PSS 2048 and SHA-256. For this purpose, a “document signer” certificate is used, which in turn is signed with the issuing authority’s Country Signing Certification Authority (CSCA) certificate. The CSCA certificate forms the root of trust for the issuing authority’s ePassport PKI, a hierarchy using certificates to prove the data authenticity and integrity of ePassports. Due to the sensitive nature of this root of trust, the public portion of the CSCA certificate is distributed between nations through diplomatic exchange.
During validation of an ePassport, passive authentication cryptographically verifies the digital signature of the data stored on the chip and traces the signature back to the issuing authority’s CSCA certificate. This way, it can be determined if the issuing authority actually stored the ePassport data on the chip, and if this data is authentic and unmodified. As part of the ePassport validation process, border authorities may optionally check a revocation list of document signers published by the issuing authority’s CSCA. In the highly unlikely occurrence of a revocation, to minimize the number of ePassports affected by any one document signer certificate, the document signer certificates are changed at least every 90 days.
An alternate means for ePassport certificate distribution is the ICAO Public Key Directory (PKD) service. Participating countries, such as Canada, share their document signer certificates and revocation lists through this secure directory.
In addition to passive authentication protecting against data tampering, the chip is fused (permanently locked) after being encoded. This feature prevents any further writing to the chip.
Unauthorized reading: Basic access control
The personal information stored on the chip is privacy protected by basic access control (BAC). For the chip in the Canadian ePassport to be read, the passport must be held within 10 centimeters of a reader and the date of the individual’s birth, the date of expiration of the passport and the passport number must also first be provided to the reader (either by manually entering the information or from the machine readable zone when the book is inserted in the reader). Without this information, the information in the e-chip cannot be accessed.
BAC also protects the wireless communication channel after access is granted by generating a session encryption key with the reader and then encrypting all data transmitted both ways between the chip and the reader. The information cannot be read or easily decrypted by a radio frequency (RF) eavesdropper.
Cloning: Active authentication
An ePassport without chip copy protection could potentially be cloned by an impersonator with a substituted chip. This is an insignificant issue since the existing physical passport security features and passive authentication protect the ePassport against tampering.
As a preventative measure to detect cloning, active authentication (AA) is implemented in ePassports. AA works by including a cryptographic key pair unique to each chip. While the AA public key is digitally signed with the rest of the ePassport data using passive authentication, the corresponding AA private key is stored in secure memory and cannot be read or copied. During ePassport validation, the chip then proves knowledge of this private key by means of a challenge-response protocol. This means that the chip’s private key signs a random challenge presented by the ePassport reader, and the ePassport reader then uses the chip’s AA public key to verify the signed response and recognize the ePassport chip as genuine.
Passport Canada Information and Communications
- Date modified:
-