Complementary Therapies
At Swedish we believe in caring for the mind, body and spirit of our patients, from diagnosis through treatment and beyond. The Ben & Catherine Ivy Center for Advanced Brain Tumor Treatment offers access to many therapies and services that can be integrated into an individual's care to complement their traditional medical care.
Complementary Therapies include:
The ACTIVE Program
Research shows that well-designed exercise programs improve both psychological and physical health for people living with cancer. The “flagship” of our cancer rehabilitation services is the ACTIVE Program (Addressing Cancer Through Individualized Exercise).
Our goal is to teach basic exercise skills to support you in achieving and maintaining the energy and strength to participate in everyday activities. For more information or to get started call the Cancer Rehabilitation Services at Swedish, 206-215-6333.
Naturopathic Care
Naturopathic physicians diagnose, treat, and help prevent diseases by creating a healthy environment both inside and outside of the body. At Swedish, we work with Naturopathic oncologists to aid oncology treatment teams in seeking the best outcomes for our patients. They may use physiological, psychological or mechanical methods. They may also use natural medicines, prescription drugs, foods, herbs, or other natural remedies.
Neuropsychology Testing
Patients who have brain tumors may experience problems with memory, attention and concentration, or other cognitive functions. These problems may be due to the tumor itself or the side effects of the treatments.
The best way to know for sure if these difficulties are significant is to undergo a neuropsychological evaluation – a comprehensive assessment of neurocognitive functioning such as memory, attention, mood, etc.
The resulting report outlines deficits and strengths and offers recommendations for future treatment, use of compensatory strategies, and follow-up testing. Neuropsychological results can help your neuro-oncologist and radiation oncologist decide which treatments might be most appropriate for you.
Your social worker can work with you to assess your needs and refer to you the appropriate professional.
Nutrition Care Clinic
Cancer treatment can have an impact on patients’ appetite and eating habits — whether through a changed sense of taste or smell, nausea, a dry or sore mouth or other side effects. Swedish offers individualized counseling for cancer patients through the Nutrition Care Clinic.
Registered and certified dietitians help patients make the optimal dietary choices based on their health needs. In addition to individualized counseling, a number of free classes are available quarterly to patients and their caregivers. Learn more about nutrition care.
Massage Therapy
Massage can relieve cancer symptoms, as well as treatment side effects such as nausea, fatigue and pain. Licensed massage therapists apply pressure to the soft tissues of the body to stimulate nerves and increase blood flow. All massages are tailored to the each patient's needs. Learn more about massage therapy.
Meditation
Meditation is a practice that is used to calm the mind and put the body in a relaxed state. Meditation can be an effective way to manage stress, pain and illness. Many patients have found meditation helpful during chemotherapy and radiation treatments.
Classes in meditation and other wellness therapies are offered throughout the year. In addition, the Swedish Cancer Institute offers a class called “Meditation for People With Cancer,” designed to teach cancer patients the principles and practice of mindfulness meditation. The class is available on a quarterly basis free of charge. Learn more about meditation.
Acupuncture
Acupuncture can be used in combination with traditional cancer treatment options to help relieve symptoms related to cancer and cancer treatment. In some cases, acupuncture may help to alleviate treatment-related side effects, such as nausea and vomiting, as well as other common symptoms, such as stress.
Some individuals also find that acupuncture helps relieve fatigue, pain and neuropathy associated with cancer and its treatment. Your social worker can work with you to assess your needs and refer to you the appropriate professional.
Art Therapy
The art therapy sessions available at Swedish introduce people with cancer to the uses of art-making as a way to express emotions. Through the use of visual media such as painting, drawing and sculpture, people with cancer find ways to express emotions, reduce side effects, increase relaxation and improve their emotional well-being. The class is also open to family members and caregivers. Learn more about art therapy.
Music