Trellon's highly effective team of developers worked together with the team at Mozilla to create a portal to give people a chance to creatively collaborate and innovate on issues affecting the open web. Just building a site where people can enter content is not enough - the nature of open web projects is decentralized, and the goal was to build a portal where content from all over the web can come together in one place and people can get involved regardless of where they live.
The Challenge
The portal's strategy had to address the decentralized nature of projects Mozilla wished to highlight. The most innovative web projects already have their own web sites, so we heavily leveraged social media tools like RSS and Twitter to pull in information where it already has a home. Another important point of the strategy was to provide the right tools for assessing the popularity of projects. People's interest could range from a simple comment to a deeper, sustained level of commitment. Popular crowdsourcing tools with simple rating systems were not going to get the job done - this is a community where the metrics for understanding popularity are measured along multiple dimensions. Trellon delivered a crowdsourcing portal that addresses challenges in the following areas:
- Highlights the people, projects and events surrounding the open web.
- Takes advantage of social media tools to incorporate content about project from existing web sites.
- Allows users to self-organize around projects of interests, tracks that involvement, and offers appropriate tools for contributing content and ideas to the project community.
- Provides fundraising and contribution tools individualized to each and every project.
- Offers administrative control over the project queue as an answer to crowd rigging and other issues.
- Release early, release often - Drumbeat is intended to be a community that will grow over time, and an important point of the project is to allow others to collaborate on the design of the portal.
Projects, People and Events
The core resources at the heart of the community are the people, projects and events. Trellon's solution allowed these resources to come together in interesting ways. People are contributors to open web projects, and we provided each user with a personalized profile pages. These pages list a set of personal information to other members, and list information about their contributions to projects. User profile pages are also used as a tool for recognizing important members of the community. Badges, roles and other forms of recognition can be displayed on a user's profile page to tell the world that they really care about the open web. Projects are spaces where people can talk about the work they do towards an open web. People can comment on projects, sign up to participate, and contribute to the project in the form of updates that go to the project maintainer. People can also support each project through financial contributions received through personalized donation forms throughout the web site. Events are listings of events in support of the Drumbeat movement. Drumbeat is an international project with events going on all over the world. People are able to get involved in events through the site, receive post-event wrap ups, and find others in their part of the world through the site.
Crowdsourcing Control
Drumbeat is all about the best projects rising to the top. One of the things our team recognized early on is that popularity was only one way of measuring importance, and that other metrics are equally meaningful in understanding the wisdom of the crowds. Each project in the site tracks multiple dimensions of project effectiveness. In terms of key metrics, each project generates numbers based on traffic, the volume of comments, the number of registered users, the frequency of content updates, the amount of donations received, and the number of people who said they 'like' the project. This system gives more insight into the effectiveness of each projet - the metrics for a project with a large body of passively interested users is much different from those of one receiving donations. Trellon implemented a system that allows Mozilla to review the metrics and determine which projects are rising to the top. In addition to the crowdsourcing tools, this kind of administrative control allows the organization to highlight and promote projects in relation to time-sensitive events.
Drupal and CiviCRM Enhancements
In order to make the site come to life, Trellon performed some enhancements to Drupal and CiviCRM. Drumbeat was designed to operate as part of a multisite installation, where information from other Mozilla web sites can be published jointly to Drumbeat. Not every Drupal module is really built for multisite, and our team developed extensive enhancements to allow the site to scale in a multisite environment, that included customized caching systems, patches for core and several contrib modules. Drumbeat tracks contact information for users within CiviCRM, and uses it for processing contributions. We customized CiviCRM to allow personalized donation pages. In order to allow people to contribute to specific projects, our team implemented a system that allowed CiviCRM to pull information out of Drupal display and track project names within the donation system. This allows for personalized donations to be efficiently administered by accountants and for the site to serve as a hub of activity.
Leveraging the Community
Drumbeat was designed to grow organically through the involvement of developers involved with the community surrounding the movement. Trellon worked with Mozilla to establish an environment for deploying changes to the web site and ensuring community members can contribute to the portal. We established a system for contributing updates to the core platform through SVN and other technologies that allows changes to be committed through the use of a simple tag. We trained developers on the installation and use of Drupal.