Do you ever miss the stories that started “back in my day”?
I used to spend weekends at my grandpa’s house helping with chores like mowing the yard or running around the chicken coups. We’d watch black and white western shows on television and then he’d tell me about how things were different in his day. They were always positive stories about appreciation for advancements in different things that made life easier or opened more opportunities for him, his family, etc.
So here’s my “back in my day”…
When I got involved in technology and computers, the primary objectives of the technology were to share files and printers. Most IT organizations were networking some servers together with the client machines, which were relatively simple so that data could move faster than the old sneaker net. At that time, we didn’t worry much about antivirus because the systems and data were simple. Fast forward, and like my grandpa, I’m appreciative that technology has made so many advancements for better patient care, faster sharing of information, predictive models for catastrophic weather, and so on. However, along the lines, this has also brought forth security problems as the data we are now storing, processing, and sharing has become increasingly valuable to threat actors ranging from nation states to unscrupulous thieves.
Due to this evolution in technology, and other world events such as the pandemic and a shift to hybrid workforce, the perimeter of most organization networks have vanished as endpoints are geographically dispersed, and more-and-more systems are connecting to resources through VPN, over the Internet, and so on. This means that the computer you are using right now may very well be the perimeter or edge of the network even though it’s not physically attached to the organization’s location. This is where the alphabet soup of acronyms come in these days with Antivirus (AV), Next-Generation Antivirus (NGAV), Endpoint Detection and Response (EDR), and finally Managed Endpoint Detection and Response (MDR). Let’s take a quick look at why these each provide a unique and valuable security layer for your systems.
Antivirus (AV) / Next-Gen Antivirus (NGAV)
Antivirus and Next-Gen Antivirus are considered the base layer of most systems these days. These provide signature-based protection against known attacks. This means that someone in the world was infected by a virus or malicious software (malware) and this was reverse-engineered by a security analyst who then created a definition file to identify and stop this same attack in the future. Next-Gen Antivirus (NGAV) takes this one step further by learning the normal patterns/behaviors of the system to detect anomalous behavior. This leads to greater efficiency and often reduced performance impact on the machine while maintaining a similar level of defense.
Endpoint Detection & Response (EDR)
So, it sounds like NGAV does a pretty good job and is a smart solution, so where does EDR come into play and provide additional valuable security? EDR is primarily focused on gathering and analyzing security threat-related information from workstations or other endpoints to find indicators of compromise (pre-breach indicators). This information usually comes from data sources such as log files, performance monitoring sub-systems, file details stored on disk or in memory, running processes, and configuration data. With all this information gathered and processed EDR can combine this data with behavioral analysis (or what’s normal) of the system and therefore be more effective, protecting against emerging threats such as novel malware, exploit chains, ransomware, or advanced persistent threats.
Managed Endpoint Detection & Response (MDR)
As the name may indicate here, MDR is an improvement over EDR because it is a managed solution, which means there is an additional layer of intelligence behind the solution usually in the form of a 24/7 human Security Operations Center (SOC). MDR utilizes the information gathered via the EDR system and provides active 24/7 threat monitoring, detection, and some level of remediation service such as guidance or system isolation to contain and prevent the spread of cyber-attacks. The data collected from the EDR system is usually anonymized and fed into a machine learning system that can compare this data against other threat intelligence to enrich indicators, validate incidents, and then the MDR provider can take appropriate actions like threat containment and support.
The graphic below from Sophos depicts from left-to-right the evolving solutions related to AV/NGAV to EDR to MDR. Note that Sophos refers to MDR as Managed Threat Response (MTR).
“Back in my day”…there were fewer acronyms because the technology was simpler and the stakes were lower. In today’s rapidly evolving tech landscape, businesses need a trusted partner to help them make sense of the ABC’s and the XYZ’s. A managed service provider like us at Axxys can determine which new technologies will actually help achieve your business objectives. Contact us today to learn more.