Expecting Moms: Don't Forget Your Prenatal Supplements!
There is no more important time in the lifespan for maintaining a healthy diet than during pregnancy. This point in the lifespan is unique since the health of two individuals depends upon the dietary choices of just one, namely mom. Mom's diet has an incredible impact on baby’s health – case in point, the well-known relationship between maternal folic acid intake and neural tube defect prevention. Surprisingly, there is a knowledge gap regarding the diets of expecting moms when it comes to their nutrient intake, particularly when it comes to the so-called “one-carbon nutrients”, like folic acid.
New research from Canada seeks to help address this gap. Masih and colleagues aimed to determine the dietary intake (both from food and supplements) of key one-carbon nutrients – namely folate, vitamin B6, vitamin B12, and choline – among a cohort of pregnant women (n=368). Large proportions of women in this cohort had dietary intakes of folate (41%) and vitamin B6 (50%) lower than the Estimated Average Requirement (EAR), and a staggering 87% of women had choline intakes less than the Adequate Intake. Fortunately, many women were using dietary supplements to improve their intake, particularly once pregnancy was established. Prior to conception, just under 2/3rds (60.1%) of women reported using dietary supplements that contained B-vitamins, but dietary supplement use became nearly ubiquitious once women became pregnant (92.8% and 89.0% in early and late pregnancy, respectively).
The optimist could look at these data and say that the majority of pregnant women are meeting their needs, thanks in large part to dietary supplements which contain these important nutrients. The problem is still that nearly half of pregnancies are unplanned, and in certain cases there can be a critical windows of development in which the baby needs additional nutrition (case in point, as the neural tube closes around day 28 of gestation, ensuring adequate folate intake during preconception/very early pregnancy is critical), underscoring the need for more widespread use of prenatal supplements among women of childbearing age. Beyond that, maternal use of a folic acid containing multivitamin during pregnancy is associated with a reduced risk of several pediatric cancers in the offspring, underscoring the need for adequate one-carbon nutrient intake during pregnancy. The message here to the 39.9% of women who are not using a supplement is clear: take a multivitamin that contains B-vitamins including folic acid!
The second message, which prenatal supplement manufacturers should pay attention to is that there is a need to increase the availability of choline-containing prenatal supplements. Clearly, dietary intakes of choline are low, and the majority of women are not meeting their need for this nutrient which plays a role in supporting baby’s development. Both moms and their children will benefit from an increased availability of choline-containing prenatal supplements.
Main Citation:
Masih SP, Plumptre L, Ly A, et al. Pregnant Canadian women achieve recommended intakes fo one-carbon nutrients through prenatal supplementation but the supplement composition, including choline, requires reconsideration. J Nutr 2015; epub ahead of print.
Supporting Citations:
Cavalli P. Prevention of neural tube defects and proper preiconceptional supplementation. J Prenat Med 2008; 2(4): 40-41.
Ciappio ED, Mason JB, Crott JW. Maternal one-carbon nutrient intake and cancer risk in offspring. Nutr Rev 2011; 69(10): 561-571.
Jiang X, West AA, Caudill MA. Maternal choline supplementation: a nutritional approach for improving offspring health? Trends Endocrinol Metab 2014; 25(5): 263-273.