TIGER HILLS is a multi-generational family saga with the sweeping love story of a pair of star-crossed lovers at its heart. The novel has been described as a cross between GONE WITH THE WIND and THE THORN BIRDS. This tale of forbidden, doomed love gains a fresh twist from its setting --- a picturesque coffee plantation in Coorg in southern India at the time of British colonial rule. The Coorg people, portrayed in the book as a tough and fiercely loyal group who live by a strict code of honor governed by intricate clan relationships, are relatively little known even within India. TIGER HILLS turns a lens on this land and its people during the late 1800s and early 1900s, during a time of great cultural change that was sweeping the Indian nation.
The birth of Devi, the seventh child in the Nachimanda clan, is heralded by the arrival of hundreds of herons, which suddenly swoop down from the air to land in a silent cloud of white by her laboring mother's feet. Devi's mother and the old village priest have misgivings about what this mysterious occurrence might foretell for the newborn girl. But the child grows up to be beautiful and impetuous, resilient even in the face of the early death of her mother, and all the more pampered and doted on by her father and grandmother as a result. When the Nachimandas bring a wealthy and orphaned young boy, Devanna, into the family to raise as their own, he too is immediately smitten with Devi. While Devi and Devanna are inseparable as children, with Devi functioning as timid Devanna's fierce protector and idol, they inevitably drift apart as the years roll by.
Devanna catches the eye of a German missionary, a man determined to atone for a youthful transgression by acting as a father figure to the young boy. At his urging, Devanna goes to live with the priest and a group of nuns at the mission, where he immerses himself in the study of botany and the search for rare orchids from the Coorg hills. The quiet, reserved boy excels in his studies and soon enrolls at a prestigious medical college in the city to prepare himself for life as a doctor, with the goal of bringing modern medicine to his people. During his difficult and lonely time in medical school where he becomes the target of bullying by a particularly vicious older student, Devanna consoles himself with the thought of Devi waiting for him at home. He envisions a happy union with her as the natural outcome of their childhood closeness.
What Devanna fails to see is that Devi already loves another man, one of Devanna's own clansmen. Many years ago, Devi and Devanna had attended a tiger wedding --- a Coorgi ceremony honoring a tiger-killer --- in honor of Machu, Devanna's older cousin. Machu is a hero in the classic mold: a handsome, proud man who, armed only with a knife, manages to bring down a tiger single-handedly during a hunt. He gains the instant admiration of Devi, who, even though she is only 10 at the time, knows that she wants him for her own. With great patience, Devi turns down countless proposals from other men over the ensuing years and, with some calculation and effort, eventually manages to catch Machu's eye. But even as the stars appear to align for Devi and Machu and they fall in love, a sudden and chilling turn of events forces the lovers apart, and results in a series of tragedies that befall the three central figures --- Devi, Devanna and Machu --- forever altering their lives and that of their children.
Sarita Mandanna's TIGER HILLS is an epic, old-fashioned love story that draws you in and holds your attention with great ease for nearly 500 pages, making it an impressive debut effort. Mandanna has chosen to focus on a rural, agrarian society with deep ties to the land. This is a departure from the urban, middle class and/or high caste setting that is often more familiar to readers (and writers) of Indian literature in English.
Mandanna uses a subtle touch to shape a complex world populated by flawed characters. Here, the most likable characters do venal things; the least appealing characters are heroic and weak by turns. Fathers and sons are alike yet dissimilar, with different traits becoming distilled out in successive generations: a parent's heroism might show up as foolhardiness in the next generation, while the bookish awkwardness of one generation might manifest itself as quiet scholarly fortitude in the child. Devi herself, while always captivating, is not always sympathetic, especially in her role as a biological mother to her own child and as the usurper of another woman's child. The reader is put off by her hard and brittle persona in her later years, even as they empathize with the circumstances that have made her angry and bitter. This nuanced depiction of human behavior makes for an engrossing page-turner of a novel.
In a story shot through with pain and suffering, each fateful turn of the plot is heralded by the reappearance of herons. Mandanna never fully explains the significance of the birds, which serve only the purpose of sounding a fateful note at every tragic intersection. In this context of the characters being the playthings of fate, the reader is even coaxed into looking the other way as a central and sympathetic figure commits a brutal and inexcusable act of violence that is entirely out of character. Even as the protagonists make their futile struggles against what fate has in store for them, we still root for each one to overcome, to survive, and to find joy in the face of the tragedy that mars each life.
Spellbinding as the love story and even the bloody aftermath it leaves in its wake are, the standout feature of this book is the beautiful and vivid descriptions of Coorg. Indeed, Mandanna's ability to create a sense of place and time with her well-chosen words makes TIGER HILLS read like a nostalgic love letter to a land and its people. While it occasionally gets bogged down in pretty and picturesque descriptions of places and things to the point of distraction, the writing as a whole is lyrical and lush, with a strong sense of immediacy. Coorg, now known by its native name of Kodagu, was prized by the British as a cool "hill station" to which to retreat during the brutal Indian summer. Its natural beauty has turned it into a bustling tourist attraction once again in recent years, and no doubt this book will do its part in attracting more people to this part of the world.
Tiger Hills