If you have ever suffered from anxiety it is likely that you felt helpless and that the anxious feelings you experienced were totally out of your control. It is also possible that you relied on some sort of medication or a form of counselling to treat anxiety.
It is very rare that a person who has anxiety issues will sort themselves out, without the help of a third party, whether it be drugs or psychotherapy. But what if I told you there was scientific evidence to show that we all possess the answer to solving our anxiety problems within ourselves?
Would you believe me or would you think this was beyond your capabilities?
I have had panic attacks for many years now and have employed a variety of techniques to ease them, including anti-anxiety medication, and a myriad of psychotherapies.
It is only recently that I devised a method for myself that has actually started relieving my panic attacks and feelings of anxiety. So when I read about several studies that suggest thinking positively can change the shape of your brain and help stop anxious thoughts, I felt supported in my own method.
If you are feeling anxious right now, don’t give up, there is a light at the end of the tunnel, and it starts with you.
Here are several studies that suggest positive thinking can treat anxiety.
1. Online Therapy for Anxiety
It has long been established that the amygdala is an important area for fear conditioning.
The amygdala is a small cluster of nuclei situated in the temporal lobe. It receives a stimulus that causes it to pass on electrical output to other regions of the brain that prompt typical fear reactions. These can be increased heart rate, additional sweating, dizziness etc.
The first study found that 9-weeks of online therapy led to a distinct change in the shape of participant’s amygdalae.
The study consisted of online cognitive behavioural therapy devised for people that all experienced social anxiety disorder.
Mr. Kristoffer NT Månsson, an author of the study, said:
The greater the improvement we saw in the patients, the smaller the size of their amygdalae. The study also suggests that the reduction in volume drives the reduction in brain activity.
2. Optimistic Thinking Benefits the Anxious Brain
Another region of the brain that is important to anxiety and negative reasoning is the orbitofrontal cortex (OFC).
A second study also showed a change in this part of the brain.
The study showed that just by thinking positive thoughts instead of negative ones, a person could actually increase the size of their OFC’s.
The lead researcher – Professor Florin Dolcos said:
If you can train people’s responses, the theory is that over longer periods, their ability to control their responses on a moment-by-moment basis will eventually be embedded in their brain structure.
3. Brain Training can Reduce Anxiety
In a third study, researchers found that by concentrating on a simple task, unnecessary fearful emotions could be avoided.
In this way, the brain could be trained to disregard anxiety-inducing triggers.
The study involved participants identifying which arrows on a screen were pointing left or right.
During the task, they also had to ignore all the other arrows on the screen.
When the brains scans were taken, they showed that those participants who studied the most difficult tasks actually performed better when dealing with their negative emotions.
Finally, if you need any more evidence to prove that positive thinking can treat anxiety, one further study showed a possible correlation between dementia and depression and anxiety.
4. Connection Between Dementia and Anxiety
This new research presented a high probability that stress and anxiety use the same neurological paths in the brain as depression and dementia.
The study strongly suggests that by relieving stress and anxiety in our lives, we can be at a decreased risk of dementia and depression in later life.
Scientists say there is a broad overlap between the neural pathways of the two conditions.
Dr. Linda Mah, the lead author of the study, said:
Pathological anxiety and chronic stress are associated with structural degeneration and impaired functioning of the hippocampus and the prefrontal cortex (PFC), which may account for the increased risk of developing neuropsychiatric disorders, including depression and dementia.
So, since positive thinking could actually treat anxiety, perhaps there is some truth in the saying ‘Mind over matter’!
Science will increasingly be researching the brain’s ability to cure itself of all disorders and diseases. I believe that a new paradigm of physics and biology is due, one that uses inner, non-physical experience as opposed to exterior, physical research to prove theories.
This is vital information that has been forgotten. Our future could be very different than the direction we are currently headed if we learn to use our innate faculties of renewal foe the benefit of ourselves and our world!
Nice post thanks for sharing