White Out: Rotor installation in Ghent, Belgium
A smear of paint transforms former bunkers on Ghent’s docks into a sequence of public spaces − and also into a critique of regeneration
Ghent is one of Belgium’s most important ports but during the last decade the focus of activity has shifted northwards, making the old docks near the city centre redundant. In a scenario familiar worldwide, they are now being redeveloped with a mix of offices and apartments. In the process, a 160m-long complex of canalside concrete bunkers used for storing sand and gravel- the Grindbakken- was earmarked as a new public space.
Architect Sarah Melsens and artist Roberta Gigante won the competition for its redesign and invited the Brussels-based practice Rotor to collaborate with them. In autumn 2012 they unveiled the result, which is not just a visually striking addition to the waterfront but a history lesson − a dossier on the way that buildings register the passage of time.
Melsens and Gigante proposed making cuts between the bunkers, so the public could circulate throughout them, and then to paint the whole complex white. Rotor’s intervention was to resist this total camouflage of white and instead leave some parts as they were, chosen for what they revealed about the construction of the bunkers and their subsequent life. Deciphering the evidence on site visits with people from other disciplines, including an engineer, a botanist and a former worker at the complex, Rotor identified 36 areas that together would tell a story. Retained on the walls ‘as found’, with explanatory captions nearby, these remnants are vivid and almost hyperreal amid the encompassing white.
An overriding theme of the highlighted patches is the behaviour of concrete. A wavering line across a whole bunker wall marks the boundary between one pour and the next. Other framed areas show the concrete staining and spalling as its reinforcement corrodes. At the bottom of one slanting wall the granular structure of concrete is particularly evident.
The concrete bears the imprint of industrial use
Elsewhere an expansion joint has lost its filling so now you can see the canal through the gap.Surrounded by white is a reddish square that looks from a distance to be a minimalist monochrome; its hue comes from the iron ore that was stored here once. Other colour changes on the walls reflect the former presence of water, accumulating as the drainage systems failed when the site became disused.
There are botanical clues to the bunkers’ past: for instance, the lichens that proliferate on one wall above a ghostly outline of the gravel heaps that hindered their formation lower down. ‘A lot of plants make no difference between a city and a mountainous landscape,’ says the caption beside some tenacious Biting Stonecrop. That staple of abandoned sites, Buddleia, of course makes an appearance and one wonky circle isolates a dense growth of moss. If plants and minerals have left their traces in the bunkers, so too have humans − and rather less discreetly. The captions drily distinguish between crude and more sophisticated graffiti: ‘We are dealing here with early attempts by youths in the course of discovering the possibilities of the spray can.’
The white enfilade of former storage spaces makes a vibrant contrast to its dingy surroundings
In many respects, Rotor’s Grindbakken recalls its exhibition in the Belgian pavilion at the 2010 Venice Architecture Biennale (AR October 2010). There the first impression on entering the building was of a minimalist art installation but the numerous scuffed monochromes proved to be table tops or seat covers or flooring. With its accompanying publication Usus/Usures, the display scrutinised the response to use of things and materials: ‘We looked for materials that were common and contemporary, showing mild wear as a result of moderate use,’ said Rotor.
While the approach seemed neutral and non-judgemental, the message to an architectural audience that habitually prefers the pristine was that wear is inevitable and perhaps should be embraced. ‘Wear humanises architecture and brings it to life,’ was the credo. Such sentiments are none too familiar, though they enhance Mohsen Mostafavi and David Leatherbarrow’s book On Weathering (MIT Press, 1993).
White paint has long been used by the art industry – via the ‘white cube’ – and architectural Modernists, to create unreal, Platonic voids.Here, the ‘imperfect’ white paint forms a subtle critique of this ideology, and of the ideology of regeneration itself, which so often attempts to whitewash the industrial past that it supplants and the indexical traces that humanise architecture
With so much white in evidence at the Grindbakken, and the bunkers resembling an alfresco gallery, I found myself thinking of the presentation of art in the last few decades, which has been torn between the ex-industrial space and the quintessential white cube.
In the case of industrial sites, consider the difference between Donald Judd’s hands-off renovation of Fort D A Russell in Marfa, Texas, and the treatment of London’s Tate Modern, where the disused power station has been largely emasculated by Herzog & de Meuron’s bland galleries. These Ghent bunkers are a reminder to always think twice before obliterating traces of history, making buildings more mute than they might be.
Inspected more closely, the paintwork’s lacunae reveal places of historic interest, identified by a roster of experts on site visits. The long zigzag shown here exposes a join between two pours of the concrete; in other spots, lichens and other flora, and human interventions in the form of graffiti, are islanded by the white
Naturally the arts crowd has loved Rotor’s Grindbakken bunkers, but there has also been a strong public response to its pedagogic aspects − its lessons about time and materials. The ensemble stayed intact for three or four weeks before it too was gradually appropriated by new graffiti, but happily there are many photos that record it at the outset. Meanwhile Rotor is busy curating this year’s Oslo Architecture Triennale, which will open on 19 September. The theme is sustainability and Rotor promises ‘to bring nuance and dissension to a field dominated by slogans’. That should be one to watch.
Have your say
You must sign in to make a comment.