Unlikely partners push for greater housing density
Updated
They may make for strange bedfellows but the Property Council and the Greens are seeing eye-to-eye right now on one of Perth's most controversial issues: infill housing.
They are calling for urban infill development in just seven key transport corridors where rapid transit routes are expected to be built.
The two have joined forces with the Australian Urban Design Research Centre to produce a blueprint for higher density housing across the city, building on the Government's vision of a series of urban infill hotspots.
The proposed corridors are Charles Street and Wanneroo Road, Fitzgerald Street and Alexander Drive, Scarborough Beach Road, Great Eastern Highway, South Street and Armadale Road, Hampton Road and Beeliar Avenue, and Manning Road & Stirling Highway.
According to the group's 'Transforming Perth' report, 80 per cent of the Government's total infill target of 154,000 dwellings by 2031 could be built this way.
It says focusing infill in transport corridors would create vibrant high streets, while leaving the character of suburbs intact.
It's a bold vision, and one that harks back to a time when the town square or high street was the heart of a suburb, but its proponents acknowledge there are plenty of potential hurdles.
The Property Council's executive director Joe Lenzo says it's a question of whether local councils can be brought on-side, particularly those in the inner suburbs.
"From a property development point of view, we've just about had enough of local governments who keep saying that their constituents don't want any growth, that suburbs have to be left the way that they are," he said.
"Developers are ready to spend money on infill development.
"They just need the impetus from government, and in particular the impetus from local government."
It's an issue the City of Nedlands has already faced.
In 2008, the council found itself with a fight on its hands over a proposed rezoning of Waratah Avenue in Dalkeith.
The plan, a mixed-use precinct of up to five storeys, saw locals take to their front lawns with pickets and spawned the residents' group, People Against Density Dalkeith.
A watered-down rezoning was eventually adopted after the Planning Minister intervened but several councillors were voted out over the issue.
Since then, urban infill has become a flashpoint issue across the western suburbs, with multiple protest groups banding together to form the Western Suburbs Alliance.
Its supporters now reach as far as East Fremantle, where some residents are opposing the planned oval redevelopment as the council bids to sell part of an A-class nature reserve to pay for it.
Last month, Fremantle council moved to increase housing density in non-heritage areas, in a drive to quadruple the number of CBD residents.
It is part of a plan to revitalise the city and boost economic activity through the week.
Long term consequences
Curtin University's Sustainability Professor, Peter Newman, says there are long-term consequences for suburbs that do not permit higher density development.
He says by failing to build smaller, more affordable dwellings in suburbs such as Nedlands and Cottesloe, younger residents are effectively barred from entry, which dampens economic activity.
"That's the problem, decline sets in if you don't change," he said.
"I think parts of the western suburbs will struggle in the future."
It's a problem Fremantle is dealing with, he says, following a decade-long hiatus from development.
Urban planning expert and architect, Timothy Horton, says opposition by some Perth residents to high density development is understandable, given Australia's track record.
Part of the solution to winning residents over, he says, is to create better guidelines around what constitutes good design.
"That's something that state government and local council can both use as they work with developers," he said.
In 2010, the South Australian government created an integrated design commission, which he headed, to oversee its 30-year strategic plan for greater Adelaide.
It's a model Perth could adopt, Mr Horton says, to promote public education in urban design.
And, he says it's one of a number of tools which promote good design, enabling more people to "be housed where they want to be."
"This plan shows you can get really a large part, if not all of Perth's future growth, infill growth, in some of the most desirable areas," he said.
Retaining character
Greens Senator Scott Ludlam says infill does not mean the demise of a suburb's character, which opponents often claim.
"We're not interested in bowling over heritage," he said.
"It means the fabric of our suburbs can remain the way they are."
Mr Ludlam says localised, targeted infill will bring social and environmental benefits.
"It means we can preserve our bushland and our peri-urban agricultural areas, and actually bring people closer together," he said.
The report says 1575 hectares of land in total could be developed.
Under a high density scenario, there would be 140 dwellings per hectare, equating to 220,000 new dwellings by 2031.
The Property Council says it's unlikely sufficient development to match population projections will happen without such an approach.
"There is no question in our minds that the government's targets with respect to infill will not be met unless we do things like this report puts out," Mr Lenzo said.
"It shows that they can be met in an environmentally-sustainable way."
Topics: housing, housing-industry, perth-6000
First posted