Blockchain—it’s a term we often see in newsfeeds and articles but perhaps don’t really understand. We are however supposed to know that, despite its original incarnation as the cryptocurrency, Bitcoin, it’s now the hottest technological innovation relevant to all industries and sectors—including the civil society sector.
Ben Joakim, CEO and founder of Disberse, explains that Blockchain is “in essence, a database that stores immutable [i.e. unmodifiable] transactions” on a secure and distributed network, “enabling people to exchange value peer to peer securely and transparently.” In other words, it provides us with a more secure way to interact with each other on the Internet.
The key words here are securely and transparently. For the international civil society sector, the effectiveness, transparency and accountability of organisations have come under increasing scrutiny. Ben sees it like this:
“There is a lot of pressure on the sector at the moment. Project funding is either public money, charitable money, or our own individual money. Therefore, we should expect to be able to understand how this money is distributed. The sector needs to engage with that.”
The current political landscape is also adding pressure to the sector. With nationalism on the rise in many countries, people are beginning to question investment in foreign aid. Why should they spend money to help others when they’ve got issues at home?
In short, the civil society sector needs to continually prove itself. Governments, institutions and the public want to know that the money the sector is spending is concretely contributing to improving the quality of life for individuals and communities.
This of course, is easier said than done. Between fund disbursement and impact on the ground, a number of entities are often involved, including donors, international civil society organisations (ICSO), local CSOs, and beneficiaries. Along this opaque supply chain, approximately 30 percent of the funds are lost to fraud and corruption. While this is, in part, a result from government and corporate fraud, Ben points out that “within the sector, the issues are more systemic, partly due to misaligned accountabilities.”
These misaligned accountabilities are mainly a result of what Ben identifies as the civil society sector’s dependency on the traditional grant-giving model. The model implies a one-way channel of accountability towards the donor. In fact, organisations use grants to ultimately deliver goods and services to beneficiaries. Organisations therefore need to be accountable both to the donor as well as to the beneficiaries. Accountability needs to run both ways.
While organisations undoubtedly see the need for “end-to-end” accountability, implementing this in practice is another challenge. For one, it is difficult to trace funds from end-to-end in an efficient manner. Audits are an attempt at this, though they are only post hoc checks, at which point funds may have already been lost. In addition, Ben notes the recurring transaction fees from opaque international financial institutions, as well as unfavourable exchange rates and currency fluctuations as limitations on efficiency within the sector.
With all of these challenges in mind, Ben founded Disberse: a fund management and fund distribution platform for development and humanitarian finance. By leveraging Blockchain technology, organisations can send and trace the flow of funds all the way from donor to beneficiary, facilitating “end-to-end” accountability.
Of course, Ben does not expect a complete eradication of the existing banking infrastructure. Rather, his aim is:
“to be able to provide a more efficient way of sending funds. […] Disberse is trying to create a whole infrastructure that will allow various parties to interact, so it becomes less of a chain and more of an ecosystem where everyone interacts as a partner.”
His main focus now is engaging the civil society sector and to demonstrate the benefits of Blockchain. For example, Disberse just finished one pilot project on girls’ education in Swaziland where, on top of the real-time monitoring of funds, a total of 2.5% on a disbursement of £15,000 was saved on transfer fees. According to Ben, this meant funding for three additional girls from the £375 in savings. The impact is concrete and demonstrates palpable potential if the project were scaled up.
Disberse is also working with the Start Network that manages a multi-million-dollar response fund for crisis situations on behalf of dozens of ICSOs. As opposed to traditional cash-based transfers to crisis areas through a complex chain of donors, Blockchain technology will allow organisations and their partners to disburse funds based on collective consensus within 24 hours and to ensure that they are indeed reaching the intended beneficiaries. Therefore, Blockchain will enable greater efficiency in both project implementation and monitoring.
Beyond these pilot projects, Ben has noticed that the sector is beginning to take notice of Blockchain’s relevance. However, there are still barriers to engaging—the main one being a lack of resources, which is an all too common problem for the sector. What is needed are internal champions or advocates for innovation to help organisations recognise the potential for things to be done in a different way. From there, organisations can draft a business case that allows innovators and partners to engage with their ideas and needs.
For the innovators and internal champions, Ben encourages them not to get caught up in the technical side of the technology. Instead, innovators should identify the benefits of the technology and strategies to get there. Ben believes that innovators “should ask the challenging questions, acknowledging that there is no definitive answer, as we are still in the early stages.” In these early stages, the key is for the sector to begin cooperating on exploring innovative technology such as Blockchain.
Ultimately, it is clear that Blockchain technology is coming. Lest ICSOs become irrelevant amidst the innovators of the sector, the time for ICSOs to engage is now.