Utah artist Colleen Howe is an accomplished pastelist and workshop instructor who is widely known for her sensitive and colorful landscapes of the West. Here she shares four helpful steps to achieving successful works of art.
by Colleen Howe, as told to Collin Fry
Growing up on a ranch in the Big Hole Valley of Southwestern Montana, I developed an early appreciation for nature and a love of painting the great outdoors. Along the way, I have been inspired by several great artists—Degas, Andrew Wyeth, Clyde Aspevig, and Scott Christensen among them—and I continue to study the books of John F. Carlson, Edgar Payne, and Richard Schmid. These masters, so varied in style and technique, each present beautiful color relationships and truthful representations of nature in their work.
From years of studying these great artists and from my own experimentation, I have concluded that successful painting can be achieved by paying close attention to a few basic principles. Each one of these steps builds on the previous one, resulting in a system that virtually guarantees satisfactory results. With this approach, one establishes a solid foundation and mistakes are dealt with early, leaving one free to move into the final painting stages without later disappointment and frustration.
Step 1: Establish the ConceptStarting with a strong concept is essential to a painting’s success. The picture’s concept can be a scene, an object, or a person, or it can be a color scheme or composition. For example, I love painting the West. The light and landscape are wonderful, and there is a wide variety of subjects from which to choose. In both my studio painting and my plein air work, I like to create a sense of place or a moment in time, perhaps capturing something spiritual or poetic about a location. For my painting concept I look for unique light, shadow shapes, or moods at different times of day or during various weather conditions. My goal in painting is to make the landscape breathe by depicting the atmosphere and energy of plant life and terrain.
Step 2: Experiment With Small SketchesAfter my picture concept has been decided, I create several small sketches, working out my ideas, composition, values, and color plan for the painting. Experience has taught me that I can confidently move into a finished painting if I have first worked out an interesting composition and pattern of values and color with small studies. I also find that ideas come more quickly and creatively when doing quick, intuitive sketching.
Issues of design, structure, and color harmony are much more easily dealt with when painting in a small format (usually 9" x 12" or smaller). It may seem time-consuming or laborious to include this step at first, but with practice one learns to quickly put down the important information from a scene that will be needed. Improvement in one’s work can be dramatic, with unforeseen breakthroughs happening through the sketching process. Any artist, no matter how experienced, will benefit from taking this vital step.
Step 3: Develop the Sketches Into Value and Color StudiesI continue thinking about composition in this stage as I explore value and color possibilities and try different approaches. To complete the preliminary stage, the flat value shapes are indicated, without trying to depict specific objects or things. Next, these various shapes are connected into a simple pattern of light and dark values. After this is finished, I work from the value study to make a color study of the same size, translating the values into color. When these studies are complete, I have a plan and am ready to start a finished painting.
I’ve noticed in my workshops that many students want to skip over these preparatory steps and don’t give enough thought to the basic issues of composition, value, and color. With patient effort and repeated demonstrations, I win them over to my practice of preliminary planning and sketching, which I’ve come to rely on after years of painting and trial and error. It’s wise to invest in planning at the beginning because it will pay back handsomely later, saving considerable time and allowing for much more freedom when creating the final painting.
Step 4: Paint Confidently, Using the Value and Color Studies as a GuideI keep my studies close for reference and use them as a road map as I move into the final painting. Sometimes dramatically increasing the scale from the preliminary sketch can prove difficult, and it can be hard to maintain the freshness achieved in the original. For this reason, care must be taken to avoid a labored or overworked look when translating the subject to a bigger surface. Strokes should be spontaneous and shapes kept simple while constantly referring to the preliminary studies.
For my own paintings, I work in both pastel and oil and find both media to be wonderful for building rich hues, beautiful light grays, and subtly colored whites. Always using my preliminary studies as a guide, I usually start with a wash of acrylic or watercolor. A drawing of the scene is either put down before the first washes are laid in or after, depending on whether the washes will be a general background color or an underpainting. I do my finished pastels on museum-grade Wallis paper, working with a variety of hard and soft pastels.
As my art evolves, I seem to be gaining a stronger interest in color harmony and strong composition. I’ve been doing further experimentation with my preliminary small sketches recently, and that has really helped me to progress and develop in this area. I have also been increasing both color and value contrasts in my paintings, which I feel are creating more visual impact and interest in my work.
About the ArtistColleen Howe grew up on a ranch in the Big Hole Valley of Southwestern Montana and now lives in Utah. She studied art and design at Brigham Young University, in Provo, Utah, and the University of Utah, in Salt Lake City, and also trained with Michael Workman, Sally Strand, Doug Dawson, and Ken Baxter. She has taught workshops around the United States and Europe, and she regularly teaches in Salt Lake City. She is a former president of the Pastel Society of Utah and is a signature member of the Pastel Society of America and American Women Artists. Her work has appeared in The Pastel Journal and The Artist’s Magazine, and she is represented in Utah by Apple Frame Gallery, in Bountiful; Authentique Gallery of Art and Design, in St. George; Bingham Gallery, in Mount Carmel; Montgomery Lee Fine Art, in Park City; and Williams Fine Art, in Salt Lake City. For more information on Howe, visit her website at.
A former illustrator and graphic designer, Collin Fry lives in Norton Shores, Michigan.
View an online exclusive gallery of more work by Howe.
© 2015 F+W All rights reserved.Use of this site signifies your agreement to the Terms and Privacy Policy, updated March 2007