Hesperian Health Guides
Malaria, Dengue, and Other Illnesses from Mosquitoes
Mosquitoes carry many illnesses and spread them to people through their bites. Changes in climate are making weather warmer and wetter, conditions in which mosquitoes thrive.
There are many different types of mosquitoes—some breed in swampy water, others breed in rain and stored drinking water. Some bite at night and others during the day. Some give illnesses to people only, others can also make animals sick.
Contents
- 1 Mosquitoes spread illness when they bite
- 2 Signs of common illnesses spread by mosquitoes
- 3 Which mosquito illness is it?
Mosquitoes spread illness when they bite
Viruses from mosquitoes. Many illnesses that mosquito bites pass to people are caused by viruses. As with most viruses, once the person recovers, she is immune and will not get that same virus again. But some viruses, like dengue, have slightly different versions (called serotypes), so a person can get dengue more than once. Getting dengue a second time can make the illness more serious.
After many people in a community have already had a virus, they each are immune. Fewer people get sick and the illness seems to go away. But as children are born and people who never had the illness arrive, the virus can affect the community once again. So there may be years with an outbreak of illness and years with very little. This is also why many people get sick at once if a new virus reaches a region where no one has had it.
Parasites from mosquitoes. Malaria comes from very tiny parasites that enter and then stay alive inside the cells in our blood. The parasites get into our blood through an infected mosquito’s bite. Once a mosquito passes the malaria parasites to a person’s body, they cause illness off and on for many years unless the person takes medicines that kill the parasites. After many years of living where malaria is common, a person will no longer become so ill because his body has developed the ability to fight off the parasites. Pregnant women, babies and young children need protection because they can get malaria more easily and it is more harmful to them, causing fever, anemia, and dehydration.
How illness spreads. Illnesses from mosquitoes do not spread directly between people who live together or touch each other. But mosquitoes can get a virus or parasite by biting a person who has the parasite or virus in his blood and then pass it by biting another person, so family members and neighbors often get sick one after the other. Understanding how a mosquito spreads disease will help community members understand how to protect themselves from illnesses carried by mosquitoes.
Although Zika virus is mainly spread by mosquito bites, it can also be spread through sex. Zika is usually a mild illness, but if a pregnant woman gets Zika, it can greatly harm her developing baby. Protect women from Zika by preventing mosquito bites and by using condoms.
Signs of common illnesses spread by mosquitoes
Among the illnesses spread by mosquitoes are malaria, yellow fever, dengue, Zika, chikungunya, West Nile virus, and Japanese encephalitis. There are mild and severe forms of each. These diseases often cause fever, rashes, and aches. It is possible to be infected by more than one virus at the same time. Signs help point to one disease over another, but it is often difficult to tell them apart. Health officials usually know what mosquito illnesses are present in your region.
Which mosquito illness is it?
Danger signs from mosquito illnesses that need emergency help
- Seizures and losing consciousness can result from severe malaria, severe West Nile virus or severe Japanese encephalitis.
- Bleeding inside the body or from the mouth, gums, nose, eyes, or skin can come from severe yellow fever or from severe dengue. Watch for signs of shock: the skin goes cold, blood pressure drops, and the pulse gets fast. A swollen stomach could also be a sign of internal bleeding.
If the fever is close to 40° (104°F), see a health worker soon. If it is higher, this is an emergency.
Be sure to see a health worker if you have signs of malaria and are pregnant, if you suspect an illness from mosquitoes in a baby, or there is illness in someone elderly or with serious health problems. If painful aches continue longer than 2 weeks or there is severe weakness, tingling, or no feeling in the legs, arms or face, see a health worker. These could be a sign of Guillain-Barré syndrome, a serious condition that can follow an illness from mosquitoes. It is best treated in a hospital.
Which mosquito illness do you have and what should you do?
Because these illnesses have similar signs, it is difficult to be sure which a person has. If it might be malaria, getting a malaria test without delay allows a person to start malaria medicines quickly, especially important if she is pregnant, very young or old, or has HIV. A woman who might have Zika can delay trying to become pregnant until she is better. Zika during pregnancy can be dangerous.
When the illness is mild, treat with rehydration, rest, and paracetamol (acetaminophen), even if you are not sure which illness it is. If the person feels worse or is not getting better, check with a health worker.
Informing health workers and regional health officials about who and how many people are sick can help them know when to take community-wide measures to stop the mosquitoes.
Prevention of illnesses caused by mosquitoes
In areas where there is yellow fever or Japanese encephalitis, vaccinating children and adults can prevent these diseases. Where insecticides are used to kill mosquitoes, be careful how you use them because insecticides can harm people and the environment. It may be safer and more effective to prevent mosquito bites and stop mosquitoes from breeding with other methods.