Forecast.
What is an Event?
When we talk about event models, an “event” has a broad definition. Generally speaking, it is a known circumstance that results in a data point that is outside of the typical “expected” demand pattern of an item, whether it is a very high or very low volume point (relative to the rest of the history). Events occur for a variety of reasons, many of which are likely to be specific to a particular business, industry or organization. Examples of events include large, one-time orders; one-time and recurring promotional activity; and stockouts.
For one-time events, we want to address a certain data point in the history to prevent it from skewing the forecast. With recurring events, we want to build and maintain a “schedule” of events for both the past and the future to leverage the historical pattern of the events to arrive at a better statistical forecast. Let’s take a look at two examples of events.
The example above shows a one-time event. Though the data are trending upward overall, we stocked out in February 2013; the only reason for having no sales in February was the lack of available product to fill orders. Since the forecast is based purely on the historical data, the forecast for the following February shows a significant drop.
Here is an example of a recurring event. There are significant increases in demand during periods when the product is promoted, but the timing of these promotions varies from year to year, making it difficult for the model to pick up on their effect as part of the standard seasonal pattern of the data.
While we could use the override facility to manually account for the response to these promotions, using Event Models allow us to both model what actually happened and automate the process.
First, we will examine how to build events and event schedules in Forecast Pro, and then we’ll apply them to the two examples described above.
The Event Manager
Forecast Pro TRAC Version 3.1 and Forecast Pro Unlimited Version 8.1 introduce the Event Manager, which allows us to create, maintain, and apply events interactively within Forecast Pro.
The Event Manager is available by right-clicking the graph view and selecting “Manage Events”.
Event Schedules contain one or multiple kinds of events tied to dates which may extend into the forecast period. The main window will display the selected Event Schedule (currently “_Schedule01”, which is empty). The same event schedule can be applied to many different items, and there is no limit to the number of schedules you can have in a Forecast Pro project.
We create events with which to populate our schedules by clicking the “Edit” button. Events are represented by Event Codes though they can (and should) also have a description.
To add an event, simply type in a Description, choose a code, and select “Add” to add the event code to the list. Similar to the override facility, we select “Commit” when we are ready to commit the changes. Once finished, select “Exit” to close the box.
With the Event Manager window open, we can interactively point-and-click on the graph itself to apply our events to the histories and forecasts we are working with in order to create schedules. Simply choose a data point, select the correct event from the drop-down menu at the top of the box, and click “Commit” to create an event schedule. Event schedules can be created, renamed, imported (copied) or deleted using the drop-down menu at the bottom of the dialog box.
Event schedules are saved as part of your Forecast Pro project.
Now let’s use the Event Manager to address the two examples presented earlier.
Example 1: Stockout (One-time event)
Here, we will apply a single event to February 2013 to prevent it from skewing our forecast for the next year.
First, we will open our Event Manager by right-clicking the graph and selecting “Manage Events”. Then we click “Edit” to add an event, which we will call “Stockout”, by typing its name in the “Description” box. Then, we can select “Add”, followed by “Commit”, to create the event.
Now we can exit the box. Next, we select the data point we want to apply the event to by clicking directly on the graph. Finally, we select our newly created “Stockout” event in the Event Manager:
When we are ready, we press “Commit” to apply the Event Model. Notice our forecast for next February has now been lifted since the stockout period in February of 2013 is designated as a one-time, non-recurring event:
Example 2: Promotional Demand (Recurring events)
In our second example, we are forecasting sales of mouthwash that depend heavily on promotional activity. We can clearly see the effects of past promotions throughout the historical data. Since we know when we’ve run the promotion in the past, and we know when we plan on running the same promotion next year, we can flag all of those periods as part of our event schedule to produce a better forecast.
In our Event Manager, we first create an event called “Promo”.
Next, we simply point and click on our promotional periods to select them on the graph—including January and July of next year, when we are planning to run the promotions again. We can hold the “Control” button the keyboard to select more than one period at the same time.
The screen above shows the model prior to applying the events. Notice that a seasonal model is being used and it often misses the timing of the peaks (because they are driven by promotions–not seasonality). Worse still, the forecasted future peaks do not reflect the known future promotional schedule.
The screen below shows the model after we click the Commit button to apply the events.
Notice that we are now tracking the historic peaks much better and the forecasts reflect a steady baseline demand with lifts in January and July where we’ve indicated future promotions will be run.
Summary
Events can easily throw off a forecast. While we can manually override our forecasts to account for their impact, sometimes it is best to identify the events in our historical data and incorporate them into the forecasting model for improved accuracy. Forecast Pro TRAC Version 3.1 and Forecast Pro Unlimited Version 8.1 introduce the Event Manager which allows users to create and maintain events interactively in the software.
For more information on Event Models and the underlying methodology, check out our recent educational Webinar on this topic.