A few nights ago, my husband and I were watching an episode of Dragon's Den, the Canadian version of Shark Tank, and a "social good" company was pitching their Haitian recycling program. It was a bad business concept poorly executed, but it didn't justify one of the Dragons' responses, paraphrased below:
You're going about this the wrong way! You don't create a social good business before you become profitable. You become profitable by whatever means necessary, and then you give back! That's how business works.
Now, I'll concede that there's something to the idea that a business needs to be successful in order for a positive end to be achieved. But her response is not an unusual one in the business community, and more often than not, the American Sharks who invest in social enterprises also buy this "the ends justifies the means" argument. Put another way, business people as a rule - and no thanks to Capitalism - prioritize profit over social good. If some money can be thrown at a few noble causes at the end of the line, that's great. But do what you have to do to thrive, even if that means exploitation.
In an apparent attempt to combat that mindset, there are now hundreds of startup brands on the "ethical" market that use buzzwords like social enterprise, one-for-one, and give-back to describe themselves. One would presume by the marketing that being charitable makes a company ethical, and I've seen many ethical bloggers and influencers tout these brands as such, even when there's very little data on their supply chain. But it begs the question: can a company really be ethical if workers are not provided a living wage, if they're not working in a safe environment, and if no attention is paid to the sustainability of raw materials?
While give-back brands market themselves around the social good, how much good are they actually achieving? And is it enough?
Charitable small businesses believe that they are doing something different by placing a cause front and center in their marketing. But, on a practical level, if their supply chain isn't in order, they may not be doing much more than a conventional business. They may be even worse.
After all, those big, nasty corporations their marketing subtly critiques do the same thing.
Large corporations have a history of giving back. GE matches employees' charitable giving, Johnson & Johnson recently pledged 1 million dollars towards improving air quality around the world, and, since 2006, the BP Foundation has donated more than 218 million dollars to community initiatives around the country. Even Walmart, through its Foundation, awards grants and scholarships, and donates money in $200,000 lump sums to all sorts of relief efforts and deserving programs.
Being charitable is not a new angle. You could probably make the case that it's actually an engrained component of American enterprise, as fundamental as having a business plan. Americans really love charitable giving. In fact, in 2015 alone individual citizens and American businesses gave $373.25 billion dollars to charity.
You can look at this from a couple of perspectives. On the one hand, it's really nice to know that these hugely profitable enterprises are designating at least some of their profits to charitable giving. It's certainly better than nothing, and for the recipients of these pledges, scholarships, and funds, it can be life changing.
But it also makes it awfully convenient for these companies to never address problems in their supply chain - or even company culture within corporate offices - because as long as they claim they're being responsible, they can practically get away with murder (but, more realistically, with gross negligence when it comes to their most vulnerable workers).
So, when a nicely branded "social enterprise" tells me they give back, I have questions.
Where are your raw materials sourced? Who makes your product? Where? What's the wage? Have you visited your supplier? How did you choose your supplier, and why?
If they can't answer these questions with relative ease, something's wrong.
It's not that charity is bad. Charity is very good, and comes from good human emotions like empathy, love, and maybe a bit of guilt. Charity is what's needed in times of crisis - in famine, tsunami, and war.
But charity is also a bandaid placed on broken systems.
Charities, by their nature, go where there is trouble. Uprising, corruption, colonialism, exploitation, bigotry, terror. No amount of external aid, even if given in love and good faith, can correct underlying systemic issues. Sometimes, charity makes things worse.
The documentary, Poverty Inc., explores the ways in which charity has become big business, delaying permanent infrastructure and job development. In Haiti, NGOs are often so poorly managed that money simply vanishes, given to inefficient subcontractors or wasted on lavish homes.
After an earthquake devastated Haiti in 2010, Americans donated tens of millions of dollars to relief efforts. Haitian communities were inundated with donated rice, forcing local rice farmers to compete with free product, running many of them out of business. Meanwhile, an onslaught of solar panel donations threatened local alternative energy businesses. Even if individuals were helped in the short term, the local economy was now dependent on foreign aid to keep it afloat. Not only is this unsustainable, it's unethical.
Change happens when marginalized communities are empowered to transform systems of oppression into systems of flourishing.
Social good brands must realize that there are limits to charity, and that building a charitable business model without attention to the ethics of their supply chain or the long term efficacy of the nonprofits they support is both irresponsible and dangerous.
The best possible world is one in which charity no longer needs to exist because people are able to provide for their families and their communities. It is a place where individuals are valued and not exploited. Where the root causes of injustice are addressed before they can spiral out of control.
Charity is only good now because it is necessary. But the world we should be working toward is one where people are far too important to ever be turned into charity cases, where we don't get to feel good about giving.
Where we get to claim that we're good only when we know that everyone is being treated as the sacred beings they are.
In the words of John Wesley:
Do all the good you can. By all the means you can. In all the ways you can. In all the places you can. At all the times you can. To all the people you can. As long as ever you can.
So, businesses, by all means give to charity. But take it a step further by seriously scrutinizing your supply chain for the slightest sign of injustice and exploitation. Care about company culture. Care about the environment. Vet the charities you support. Treat others the way you'd like to be treated.
I originally covered this topic on my post on One-for-Ones. I'm hoping to do another post distinguishing between charity as a virtue versus "charity, inc." soon.