The holiday season is typically celebrated by overindulgence of food and sweets and also coincides with the flu season. Contrary to popular belief, the number one cause of the common influenza bug is not the spread of germs from person to person, but poor gastrointestinal health, which creates a breeding ground for harmful bacteria and viruses to flourish in your gut. This makes you more susceptible to illness.
Americans generally overeat on many different types of foods during the holidays, many of which – let’s face it – are full of sugars and fats, and sit on the table for hours at a time while we go back for seconds and thirds, and a few more nibbles. By doing so, we disrupt the balance of good bacteria in our gastrointestinal systems and allow bad bacteria to create further disruptions that allow infection to set in.
Throughout the flu season (and also throughout the year), many experience what is called the “twenty-four hour flu”, which really is not influenza at all. In actuality, the 24-hour bug is usually a case of mild food poisoning, the symptoms of which are similar to influenza (chills, fever, vomiting, diarrhea, fatigue, weakness). Food poisoning is caused by the toxins present in the waste products of bacteria as they consume food and leave their droppings on the food you eat.
Bacterial growth occurs very rapidly between 41 degrees and 160 degrees, which is known as the Danger-Zone. Any perishable item kept in the Danger-Zone for more than 4 hours can develop enough toxins to make a person sick.
Unfortunately, while slaughterhouses, warehouses, shipping trucks and grocery stores have strict guidelines to maintain “the cold chain” and keep foods out of the Danger-Zone (whether or not they maintain this cold chain is something you have to take for granted, but is not always the case), once that food is in your grocery cart, maintaining “the cold chain” is up to you.
Follow these tips to ensure that your food is kept out of the Danger-Zone, thereby reducing your susceptibility to the flu this season. These steps will not prevent the flu, especially if you consume large amounts of sugars. Sugar is particularly harmful because bad bacteria and yeasts thrive on sugar in the gut. Try to reduce the amount of sugar you consume this holiday as well as eating lowfat yogurt every day to reestablish healthy bacteria like acidophilus, bifidobacterium, and lactobacillus or boosting your probiotic intake in other ways.
1. Buy your perishable items last while grocery shopping. With the extra-long shopping list, long checkout lanes and crowded aisles, you are going to be in the store for awhile. If you get your perishable items at the beginning, chances are it will be an hour or more until they are placed under refrigeration again. The four-hour time window starts the moment you pick up the item and it warms up over 41 degrees.
2. If you are buying a turkey or ham, be careful of which one you pick out. During the holidays, stores typically load their freezers full of meat, piling it higher than the case can actually refrigerate. If you pay attention to these cases, there is generally a “load line” clearly marked on the front and rear of the case. That load line indicates the invisible “curtain” of cold air that is produced by the refrigeration unit. Any birds or hams that are higher than the load line are actually out of refrigeration and, although they may be frozen, they can still produce “hot-spots” where bacteria will flourish. Dig for ones on the bottom, or below the “load line.”
3. The safest place to thaw a turkey is in a refrigerator, but this process takes several days. Buy your turkey early and place it on a large plate in the bottom of the fridge. This will prevent any drippings from contaminated good food, especially any raw food you may not cook before eating. DO NOT THAW the turkey on the countertop. Doing so puts the turkey in the Danger-Zone for a considerable amount of time. ONLY thaw a turkey by water if needed in the final stages, and only if the turkey will not be out of refrigeration over a half an hour to do so.
4. Proper storage in your refrigerator is critical as well. An overloaded fridge can create a great growing conditions for bacteria as the fridge struggles to maintain the correct temperature. If you have a second refrigerator, split the food between the two.
5. Injecting your meat can contaminate it by bringing surface bacteria into the center of the meat where cooking temperatures may not reach as high. Always rinse the bird thoroughly, inside and out before stuffing or injecting to prevent this from happening.
6. If stuffing your bird, be sure not to contaminate the stuffing from juices from the raw turkey. First, rinse the inside cavity well. Then use a separate bowl for spooning the dressing, and make sure to throw the leftover dressing (for the bird) away. Also, always use separate cutting boards and utensils for meat products or wash thoroughly before using with any other foods.
7. All poultry should be cooked to an interior temperature of 165 degrees or higher. Use a long meat thermometer and be sure to get to the center of the bird (if stuffed, the center of the stuffing) to get the right reading. Remember that the four-hour window applies to all leftovers as well, so constantly taking the foods in and out of the refrigerator and reheating will take time off the life of the food as well. Be sure to reheat all foods thoroughly.
***Note: No amount of cooking will prevent foodborne illness from food that has been in the danger zone for too long. Foodborne illness is not caused by bacteria, rather, from the toxins present in its waste. You get sick from bacteria’s poop.
8. Be wary of the food on the table or the hors d’oeuvre platter if it has been out more than a couple of hours. Refrigerate all foods as soon as possible or, better yet, make sure they are on ice while they are displayed.
9. If preparing casseroles or dishes to be warmed-up later, always cool down as quickly as possible. Do not simply let it sit on the counter “until it cools” as this will place the food in the Danger Zone for a long period of time.
10. If serving warm foods over a period of time, place it in a warmer or chafing dish to maintain its temperature at least above 150 degrees.