There are, it turns out, more types of people in the world than we could have dreamed of.
There are mere mortals like you and me, the kind of persons who come into this world, red-faced, kicking and hollering and then exit again, usually a few score years later. To lawyers and the supreme court, we’re known as “natural persons”.
Then there are corporate persons.
British jurist William Blackstone defined these folks back in the mid-18th century, when he was grappling with the fact that rights and duties attach to organizations, and not just mortal human beings. Yes, he concluded, there’s a need for “artificial persons”, who can enjoy “a kind of legal immortality”.
I find myself wondering just how rapidly the eminent Mr Blackstone’s body is turning over in its crypt in Wallingford, England, in the wake of the supreme court decision on the Hobby Lobby case this week.
It seems that now it’s possible for the “natural people” who own the chain of craft stores, to transfer to the “artificial person” (the corporation that they control) their thoughts, convictions and emotions.
What that means in practice, the justices ruled 5-4, is that the company doesn’t have to provide or pay for a health insurance policy that includes some forms of contraception, even though it would be required to do so under the terms of Obamacare.
Their reasoning? Since the company’s controlling shareholders operate their business along religious lines, and they argue that paying for these forms of contraception would violate their religious beliefs, providing the insurance plans represents a violation of the corporate citizen’s rights.
Or, depending on how you parse it, the natural person’s rights, conflated with those of the artificial person.
The Hobby Lobby decision probably won’t send us skidding down the slippery slope toward the end of democracy as we know it. But it tilts the scale still further in favor of artificial people – corporations – a trend that constitutional scholars on this side of the Atlantic have been warning about for decades.
In a 1933 decision, supreme court justice Louis Brandeis cautioned that corporations, granted too many of the rights normally reserved for human beings, can end up dominating the state.
Some were sounding the alarm even before the Citizens United case (in which the supreme court ruled that campaign contribution restrictions limited the free speech rights of these corporate citizens) in 2010. The SUNY Buffalo Law School convened a daylong panel in 2005 revolving around the theme of “Planet of the APs”, making a play on the shorthand for artificial persons. The subtitle: “Are corporations and other artificial persons taking over the legal system?”
Here is the dilemma. We need corporations to have some of the same rights that “natural persons” do. It’s not just a convenient legal fiction, but a necessary one. Without it, you’d have no one to sue when your defective product malfunctioned or your bank defrauded you. You couldn’t sue your employer. If the Guardian or the New York Times didn’t have legal status as corporations, the freedom to insist on publishing what is clearly important for our readers to know would be meaningless.
Giving corporations status as “artificial persons” gives them the ability to stand up in a court of law on behalf of their own interests and customers, to enter into legally-enforceable contracts, and to be held accountable for their misdeeds. Those, we’d all agree, are good things.
The problem is when corporations push the envelope. True, no artificial citizen has yet to demand the right to vote (although I did once catch an April Fool’s Day episode on National Public Radio in the wake of the Citizen’s United Decision to that effect – it briefly had me wondering.)
But the Hobby Lobby decision, I think, has us all teetering on the brink of corporate anthropomorphism: just how natural can an artificial citizen get in this era of artificial intelligence? How many of its owners’ ideas, emotions and convictions can we legitimately ascribe to it?
For the corporations-are-people-too reasoning to work, it needs to feel logical to the rest of us – the sentient part of the population, who breathe, sleep and do all the stuff that corporations don’t (including die). Somehow, a democracy just doesn’t feel, well, democratic, when the potential exists for a big, privately held corporation is a major player in the economy and dominates its industry. It doesn't seem right for a corporation, comprising tens of thousands of people, to claim that it has religious feelings about a law that make it impossible to comply with that law – regardless of what those thousands of employees, its customers, or the elected representatives who passed that law believe. What company am I talking about? Well, take your pick. It could be a business like Cargill, a giant player in the agricultural industry; Bloomberg, a dominant force in journalism and finance; or Koch Industries, the second largest private employer in the country, according to Forbes.
About 90% of the companies in the United States may qualify as closely-held businesses. They may now have a right to express religious feelings, and to have those taken into consideration should they find complying with a law unpalatable.
This issue becomes more significant when we stop and think about the most important way in which we can’t treat a corporation as an individual. Yes, when a company misbehaves, the Justice Department can file criminal charges. But often, that’s a last resort, rather than the automatic action that it is in the case of individuals who run afoul of the criminal justice system.
Then, too, what punishment can be levied against a company? There’s no perp walk for corporate citizens. Yes, there’s reputational harm, but compared to what happens to an individual who has been accused of, say, downloading child pornography, or even drunk driving, it’s chicken feed. Artificial persons don’t have emotions and don’t feel shame. If their name loses its power, they can re-incorporate under another one.
That leads to another pesky question: what to do with corporate malefactors? Credit Suisse just pled guilty to criminal charges of tax evasion and agreed to pay a record $2.6bn fine. But the bank hasn’t been marched off to jail. BNP Paribas pled guilty to conspiracy charges and will pay a $8.8bn fine that equals one and a half years of its profits. That’s not a terribly effective solution anyway, as it leaves thousands of innocent bystanders – employees not involved in the wrongdoing – unemployed, as we saw in the case of Enron.
The supreme court opened the door to viewing artificial people as slightly more human in both the Citizens United and Hobby Lobby Cases. Let’s hope they realize the risks of their anthropomorphism before they step across the?)