 client who I considered a friend. He was a very positive and optimistic person who unfortunately was overcome by cancer at age 58. These losses in my life are incredibly sad, but also serve as a reminder of how important it is to address end-of-life issues.
Richard did his best to prepare his family for the worst, and in my opinion he did a very good job. However, his wife Rebecca found all the documents and planning confusing and stressful when added to the grief of losing her husband. After talking about the challenges of facing these issues, Rebecca and I decided together to share some important lessons on how to prepare, as a couple, for the loss of a spouse.
Communicate and Plan Ahead
What are your preferences for hospital treatments? Would you or your spouse want to be resuscitated in the hospital? Do you prefer to be buried or cremated? What kind of memorial service would you prefer? These are all difficult but important aspects of death that should be discussed long before they become relevant. By communicating about your respective wishes, you give each other the gift of removing doubt and uncertainty from at least one aspect of the grieving process.
Moreover, wherever it makes sense, put your wishes in writing. Whether it’s a Do Not Resuscitate (DNR) directive, a will outlining preferences for burial, or an update to your preferred account beneficiaries, putting it all in writing and ensuring these documents are legally valid will reduce tension around these decisions. One unexpected but common occurrence after the death of a loved one is dispute about what his or her wishes really were, which is often fueled by grief and shock; by making your wishes clear ahead of time you can also go a long way towards alleviating family conflict.
Know Your Business as a Couple
Even if one member of the couple takes primary responsibility for financial planning, you should both be fully apprised of everything that is going on in your financial lives. The easiest way to do this is to check in regularly about your plans. Still better, start and regularly update a list of your financial details, including bank accounts, safety deposit boxes, investment accounts, insurance policies, pensions and other retirement accounts, and Social Security benefits. You should also make a list with the contact information of advisors such as financial advisors, insurance brokers, lawyers, and accountants. Keep your files organized so that your loved ones can easily find out about any outstanding debts and keep track of loose items like stock certificates.
Both you and your spouse should also at least be aware of the basic steps that would need to be taken to transfer accounts and claim benefits in the event of a death. Even just having an idea about the procedure will go a long way towards reducing the confusion that can come with all the paperwork.
Keep this information alongside your personal documents, such as health directives, wills and trusts, and directives pertaining to burial and memorial services. The surviving spouse will inevitably have a lot to do, and grief can make even the simplest tasks so much harder. Having all the information in one place will help. For more information about financial planning after the loss of a spouse, please read Organizing Your Finances After the Loss of a Spouse.
Also keep in mind that with the loss of a spouse, the surviving spouse may see significant changes to income and lifestyle needs. Understanding your current spending and anticipating how your budget might change in the event of a death can help you plan ahead to ensure your financial security. Either way, it is a very good idea to understand your spending habits in order to effectively manage your budget. Making Sense of Your Spending Habits is a brief article with information on tackling this process and includes a spreadsheet to help get you started.
Take Care of Yourself
Be sure to take time out to take care of yourself, especially if you are currently a caregiver to your spouse. Caring for your loved one is not only physically demanding but incredibly emotionally demanding as well, and it can be hard to recognize the need to take time out to rest. Remember that without fortifying yourself, whether it be through a nap, reading a book, a hobby, exercise, or time with friends, you won’t be able to care for your beloved as effectively, so push through any feelings of guilt and remember to be good to yourself too.
Taking care of yourself is just as important in the event that your spouse passes away. Whether it’s a surprise or the result of a long-term illness, the death of a spouse is likely to affect you for years to come. Unfortunately, with the loss of a spouse there is often a lot of good advice about what to do or how to feel, but what you hear won’t necessarily be the right advice for you. Don’t feel bad about not listening to everyone, as hard as this can be during such a tumultuous time. I find that people believe they should feel or act a certain way, and that doing otherwise would be wrong, but in reality you have to do what’s right for you based on your individual feelings. This is a critical part of caring for yourself during such a difficult time.
Seek Help and Advice
It’s important to know that you can turn to friends, family, and your advisors and that they will be there to help during the worst of times. Don’t be afraid to let your loved ones help out, and don’t be afraid to ask for help; don’t feel embarrassed that you’re not completely educated on everything that’s going on.
Having a professional advisor to turn to can also help to reduce the stress and uncertainty around the financial planning required after a death. Whether it’s by moving accounts, quarterbacking other professional advisors, or providing an empathetic sounding board for your fears and questions, a good advisor will provide you with logistical and compassionate support that isn’t just limited to financial advice. However, remember that the best time to ask for advice is before you need it: Get familiar with your advisor ahead of time and take the time now to tackle these important questions and issues. If your spouse primarily deals with your advisors, make sure you get to know them a bit too so that you feel comfortable turning to one or all of them in a time of need.
Conclusions
While it’s often hard to broach the subject, communicating openly with your spouse about your respective preferences, planning ahead, and keeping each other informed are a vital part of helping each other in the event of a death. As Rebecca described it to me after the loss of her husband, it is such a vulnerable time in her life. If you can communicate and plan ahead you’ll be better positioned to get through the process.
This article is dedicated to the memory of my good friend Richard. Thank you to Rebecca for sharing her thoughts and advice for this article.
.
..