CERN Courier
Jan 1, 2003
ASACUSA measures microwave transition in antiprotonic helium
Recent months have seen the much-awaited synthesis of cold antihydrogen atoms by two groups working at CERN's Antiproton Decelerator (AD; Amoretti et al.; Gabrielse et al.). The aim of these collaborations is to compare spectral features of hydrogen and antihydrogen as a test of the CPT invariance principle, which states that under certain realistic assumptions about the quantum fields that represent them, matter and antimatter will always behave in the same way. However, it is not just in antihydrogen atoms that CPT symmetry can be tested, as the ASACUSA collaboration is demonstrating.
If CPT violation occurs anywhere in nature, it must be very small, and experimental searches for it have usually been done with kaon beams. These beams are coherent superpositions of particle and antiparticle waves, and since slightly different masses imply slightly different de Broglie wavelengths, a limit of a few parts in 1019 can be placed on any kaon particle and antiparticle mass difference by a detailed study of the interference effects observed in them. However, kaons are mesons, containing both a matter and an antimatter quark, and CPT violation might not show up in conjugate pairs of this kind. Protons (p) and antiprotons (p-) are made only of quarks and antiquarks respectively; hydrogen (H) and antihydrogen (H-) atoms are made only of quarks and leptons, and of antiquarks and antileptons. In such systems, CPT violation at some small but crucially important level can certainly not be excluded with equal rigour.
Although we have no quantum interferometer for the CPT conjugate H-H- pair, we do have powerful laser beams, which we can use to probe its members with extremely high precision. Since no other assumption than CPT invariance need be made in interpreting what happens when one of them is removed from a spectrometer and replaced by the other, the H-H- pair is in many ways the ideal CPT test-bench. However, it is very difficult to produce antihydrogen atoms moving so slowly that they do not drift out of a laser beam before it can stimulate one of their spectroscopic transitions. Solutions to this problem are now evidently in sight, but many difficulties remain before the extreme sensitivity afforded by laser techniques (and indeed necessary for meaningful tests of CPT invariance) can be reached.
ASACUSA's alternative approach involves the much easier task of replacing an electron in an ordinary atom by an antiproton and measuring the spectroscopic frequencies of the resulting "antiprotonic atom". However, we do not have the CPT conjugate "protonic antiatom" with which to compare it, and must calculate its transition frequencies from quantum electrodynamics, assuming the known proton values for the antiproton (and also that the calculations were done properly). In this way, the ASACUSA collaboration has determined the relative charge and mass of the proton-antiproton pair to six parts in 108 (Hori et al.) by laser-stimulating optical-frequency transitions in antiprotonic helium (figure 1) - the only variety of antiprotonic atom known to live long enough to permit such quantum gymnastics (CERN Courier October 2001).
How might we use this atom to investigate the antiproton's magnetic properties? Unknown large-scale fields are sometimes measured by determining the energy required to turn over a magnetic dipole of known strength placed in them. At the atomic scale, this is the basis of classic experiments on magnetic effects like the ground-state hyperfine splitting in hydrogen. Likewise, by measuring the energy of the photon needed to flip the known magnetic dipole of the electron in the unknown magnetic field of the antiproton, we can measure the latter particle's own dipole field.
ASACUSA has now carried out such an electron spin-flip experiment (Widmann et al.), in which two laser beams and a microwave beam were tuned to resonate with the antiprotonic helium atom (see figure 1 for an explanation of this "triple resonance" experiment). Microwave resonance peaks occurred at 12.89596 and 12.92467 GHz, corresponding to electron spin-flips in states of the atom with antiproton spin "up" and "down". These values are consistent with calculated values assuming the proton's orbital magnetic dipole moment for the antiproton, and limit any difference between them to less than six parts in 105. The measured values also depend on the antiproton's spin magnetic moment, but the corresponding limit for this (1.6%) is not yet as good as the value (0.3%) deduced from the fine structure of X-ray spectra in heavy antiprotonic atoms. A precision measurement of this latter quantity will require major improvements in the laser system. Therefore what will probably come next from ASACUSA are even tighter limits on the orbital moment, charge and mass.
The present result has an unusual feature. According to the equation for m-p (see figure 1), what is being measured is mainly the ratio g1p- / g1p of the factors defining the orbital current magnetism relationship for the members of the CPT conjugate pair. However, we have no atoms with orbiting protons in our matter world, and g1p has always implicitly been taken by definition to be equal to 1. Thus while CPT invariance is respected within the six parts in 105 limit given above, we do not know, in the empirical sense, that either g-factor really has the value unity.
Further reading
Amoretti et al. 2002 Nature 419 456.
Gabrielse et al. 2002 Phys. Rev. Lett. 89 213401.
Hori et al. 2001 Phys. Rev. Lett. 87 093401 and Rev. Part. Phys. 2002 (Phys. Rev. D 66) pp57 and 73.
Widmann et al. 2002 Phys. Rev. Lett. 89 243402.
About the author
John Eades, Tokyo.