Why You May Not Want To Run Your Own Mail Server
Introduction
When setting up a web site or application under your own domain, it is likely that you will also want a mail server to handle the domain's incoming and outgoing email. While it is possible to run your own mail server, it is often not the best option for a variety of reasons. This guide will cover many of the reasons that you may not want to run your own mail server, and offer a few alternatives.
If you do not want to read the entire article, here is a quick summary: setting up and maintaining your own mail server is complicated and time-consuming, and there are several affordable alternatives—most people will get more value, in the form of saved time, out of using a paid mail service. With that said, read on if you want more details. the the required components,:
- To send mail from your users to an external MTA (another mail server)
- To receive mail from an external MTA
Examples of MTA software: Postfix, Exim, and Sendmail..
Examples of MDA software: Postfix and Dovecot.
IMAP and/or POP3 Server
IMAP and POP3 are protocols that are used by mail clients, i.e. any software that is used to read email, for mail retrieval. Each protocol has its own intricacies but we will highlight some key differences here. provide IMAP and/or POP3 server functionality: Courier, Dovecot, basically mail client that can be accessed by users via a web browser--Gmail is probably the most well-known example of this. The webmail component, which requires a web server such as Nginx or Apache, can run on the mail server itself.
Examples of software that provide webmail functionality: Roundcube and Citadel.
Maintenance is Time-Consuming
Now that you are familiar with the mail server components that you have to install and configure, let's look at why maintenance can become overly time-consuming. There are the obvious maintenance tasks, such as continuously keeping your antivirus and spam filtering rules, and all of the mail server components up to date, but there are some other things you might have not thought of.
Staying Off Blacklists
Another challenge with maintaining a mail server is keeping.
If your mail server gets blacklisted, it is often possible to get it unlisted (or removed from the blacklist). You will want to determine the reason for being blacklisted, and resolve the issue. After this, you will want to look up the blacklist removal process for the particular list that your mail server is on, and follow it.
Troubleshooting is Difficult
Although most people use email every day, it is easy to overlook the fact that it is a complex system can be difficult to troubleshoot. For example, if your sent messages are not being received, where do you start to resolve the issue? The issue could be caused by a misconfiguration in one of the many mail server components, such as a poorly tuned outgoing spam filter, or by an external problem, such as being on a blacklist.
Easy Alternatives — Mail Services
Now that you know why you probably do not want to run your own mail server, here are some alternatives. These mail services will probably meet your needs, and will allow you and your applications to send and receive email from your own domain.
- Google Apps
- Zoho
- FastMail
- Gandi (requires that the domain is registered through them)
- Microsoft Office365
This list doesn't include every mail service; there are many out there, each with their own features and prices. Be sure to choose the one that has the features that you need, at a price that you want.
Easy Alternatives — Postfix for Outgoing Mail
If you simply need to send outgoing mail from an application on your server, you don't need to set up a complete mail server. You can set up a simple Mail Transfer Agent (MTA) such as Postfix. A tutorial that covers this can be found here: How To Install and Setup Postfix on Ubuntu 14.04.
You then can configure your application to use
sendmail, on your server, as the mail transport for its outgoing messages.
Not Convinced?
If you really want to run your own mail server, we have a few tutorials on the topic. Here are links to a few different setups:
- How To Configure a Mail Server Using Postfix, Dovecot, MySQL, and SpamAssasin
- How To Set Up a Postfix E-Mail Server with Dovecot
- How To Install iRedMail On Ubuntu 12.04 x64
- How To Install Citadel Groupware on an Ubuntu 13.10 VPS
- How To Install the Send-Only Mail Server "Exim" on Ubuntu 12.04
- VirtualMin
Good luck!
57 Comments