Conventional wisdom says if something sounds too good to be true, it probably is. This is a good principle to live by and can keep you from making impulsive decisions, like emailing your bank account number to a mysterious businessman who urgently needs you to help him transfer $100 million to another country. However, for every financial pearl of wisdom, there are exceptions. There are times when you may be able to save significant taxes from the sale of a qualified small business (QSB) by understanding Sections 1202 and 1045 of the Internal Revenue Code (IRC). It might sound too good to be true, but truth can be stranger than fiction.
To C Or Not To C
When creating a startup, many entrepreneurs lean toward forming LLCs or other structures with pass-through tax treatment. A C corporation can be overlooked because of double taxation. Double taxation can occur when a corporation pays taxes on its profits at the entity level, and then a second layer of tax is paid at the personal level when dividends are distributed to shareholders. However, there are strategic reasons for using a C corporation that can allow you to come out far ahead.
What Are QSBS And IRC Section 1202?
Qualified small-business stock (QSBS) refers to shares of a QSB that is a domestic C corporation with gross assets (valued at their original price) of no more than $50 million at the time of stock issuance or immediately after it. In 1993, Congress enacted IRC Section 1202 to create an incentive for investing in small upstart businesses. Section 1202, also called the small-business stock gains exclusion, allows capital gains from select small-business stock to be excluded from federal tax. To exclude Section 1202 gain, however, eligible shareholders, qualified stock and the issuing corporation all must satisfy certain requirements. These include, but are not limited to, that the investor must have had the stock for a minimum of five years, cannot be a corporation and cannot have acquired the stock via the secondary market.
Only permissible businesses are eligible. Those businesses involving personal services, such as banking, insurance, finance, engineering, architecture, leasing and investing, as well as others such as farming, mining or operating a hotel, motel or restaurant, do not qualify.
If these qualifications are met, there is a tiered structure for the taxes that you may exclude. According to Tarik Awad, of Cohen & Co., the eligible gain is limited to the greater of $10 million ($5 million for married filing separately) or 10 times your tax basis in the QSBS. He also notes that certain states such as California, for example, does not follow the rules of Section 1202, so gains could be taxable in your state.
A Big Ending Can Mean Big Savings
To understand how these strategies can work, let’s consider an illustrative example of a startup owner, Ms. Smith, who established her business in 2013 and sold it in 2019 for $100 million. Let us assume Ms. Smith was the sole owner and started the company as a C corporation with a $10 million cost basis in her stock. Since the company was sold five or more years later, the entire gain would be free from federal tax — evading the alternative minimum tax and the 3.8% net investment income tax (NIIT). This could have resulted in over $21 million in federal tax savings (based on multiplying the $90 million gain by the top long-term capital gain tax rate of 23.8%).
IRC Section 1202 Meets Section 1045
Not only can Section 1202 potentially help you, but so can Section 1045. It is like a 1031 exchange for real estate, except it applies to QSBs. Essentially, it states that if you sell QSBS that has been held more than six months, you can roll over your gain within 60 days by buying shares of another QSB. Section 1045 allows founders and investors to move money from one business venture to the next under certain circumstances — and avoid tax on the appreciation from the first venture.
To illustrate this using the example above, let us assume Ms. Smith exercised a 1045 rollover with $20 million of her profits from the sale of her startup and invested that into a new technology company. If she held the stock of the new venture for five or more years and then sold that business interest, the cost basis rule would apply, and she could mitigate tax on the sale of up to 10 times her QSBS cost basis, or $200 million ($20 million multiplied by 10). Had the company later sold for $200 million, she would have saved over $42 million in federal and NIIT taxes (based on multiplying the $180 million gain by the top long-term capital gain tax rate of 23.8%).
Dynamic tax savings are possible once you know how to leverage these lesser-known sections of the U.S. Internal Revenue Code. Remember, though: QSBS planning only applies to C corporations and with several key qualifiers. So, if you’re thinking of setting up a new business venture, you must not only consider how you’re going to start the business, but also how you’ll exit. Yes, you must spend money to make money, but it’s not always what you make that matters. It’s ultimately what you keep that counts.
The information provided here is not investment, tax or financial advice. You should consult with a licensed professional for advice concerning your specific situation.