I still remember the response of a canny old Scottish finance director to my question of what he thought his auditors did for the company. He smiled. “Well,” he said. “I always leave a full page for them in the annual report and one day maybe they will tell us all what they have been up to.” They didn’t, of course. They simply filled in the usual standard boilerplate statement. The only difference between then and now is that the boilerplate can now stretch over innumerable pages. And the investors, shareholders or stakeholders are still none the wiser. They simply assume that if it is the same stuff as last year then probably all is well.
There was another difference in the era of shorter audit reports. There were many more companies finishing up with qualified audit reports. So much so that every six months we junior journalists had to put together a table showing which public companies had transgressed, what the auditors had said, the nature of the particular crime and then a league table of the most prevalent transgressions.
The other day I asked the Auditing Practices Board how many qualified audit reports there are these days. There are very few substantive qualifications of listed companies these days, came the answer. And the specific numbers? Perhaps two a year, they said.
It is a very different world. But it is also one where the amount of disclosure is massive compared to the old days. And the assumption is that deep within that disclosure are explanations of all the contentious stuff which one day would have been the subject of heated rows between the finance director and the audit partner, leading to a stand-off and an audit qualification.
Now the details are all there in the disclosures. The problem with that is that it puts the onus on the shareholders to spot the stuff. And any difficult issues can, deep within the detail, be spun to make them sound either innocuous or of trifling interest, or both. On the other hand, as we all know, the best audit scandals, from Polly Peck to Enron can, with hindsight, be spotted deep in the notes to the accounts. It is a question of not seeing the wood for the trees.
What is needed is that audit reports become more useful. But this is unlikely to happen. They have already burgeoned to enormous size and tell us less. Finance directors ought to get involved in efforts to make them more useful. The Auditing Practices Board put out a useful discussion paper at the end of last year. It details how we got to where we are and what might happen next. But it does make you feel that the weight of detail has everyone already halted in their tracks.
It you talk to a veteran in the field you get the same view. Ken Lever is chairman of the Financial Reporting Committee of The Hundred Group of Finance Directors. For him the problem is the boilerplate. “Twenty years ago when I was an auditor, the auditor’s report was ten lines long and that was it,” he says. “Now it rabbits on about all sorts of things for pages. The man on the Clapham Omnibus wouldn’t have a clue what it meant.”
What he would like to see is more useful pointers to where the issues might lie and he thinks that the world of corporate finance might provide some help. “If the auditor does a long-form report for due diligence,” he says, “they specifically refer to a whole bunch of relevant things and they highlight specific things.” Transplanting that sort of attitude into run-of-the-mill audit reports would help. “People might feel more confident if auditors had to do that.”
But the culture is against it. People don’t read the boilerplate but they know what it should look like. “The problem,” says Lever, “is that if it varies from the standard wording then people become worried.” And from this develops an attitude of complacency. “Currently, as long as company A’s boilerplate is the same as company B’s then everyone is comfortable.”
But there is a wider trend that all this could fit into. Increasingly, people are asking whether much of the official financial reporting and disclosure could be broken up into smaller chunks, each aimed at specific users. There could be a case for making the auditor’s report simply shorter and clearer and dumping the rest of the stuff elsewhere.
We could, for once, follow the French. They do precisely that and publish the boilerplate separately and specifically for the benefit of the lawyers. And, as someone pointed out to me, the lawyers then chuck it away.
What users of reports need is a greater understanding of what auditors actually have done. That is what my Scots FD wanted to talk to them about. Do they just scratch the surface and rely on the internal controls? Or do they do more than that?
The Auditor’s Report: A Time For Change? is available from the Auditing Practices Board and can be downloaded from. A public discussion on the issues it raises is to be held on 26 March.