Health With a Capital H
Optimizing Mobile Email Marketing Amid the “Device Revolution”
March 9, 2012
Contributed by Alison Logan
Here at IQ Solutions, we have wondered, as social media use continues to climb, will we see a decline in the success of email marketing? According to Pew Research, among younger audiences, social networking sites compete with email for users’ time and attention. In addition, Marketing Sherpa’s 2010 Email Marketing Benchmark Report indicated that 70 percent see social media as a serious competitor to email marketing for users’ time and attention.
With this question in mind, we captured some key take-aways from a recent Lyris webinar on revitalizing email marketing efforts in the age of the “Device Revolution” and merged them with some of our own best practices.
Lyris, citing 2011 eMarketer research, reports that 96 percent of Americans own a mobile phone and 44 percent use a smartphone with Internet access. A whopping 45 percent of the time, people use these devices to check their email; however, when they are checking email, they have limited time and phone battery power, and are often distracted.
Based on these facts, we’ve put together some recommendations for your mobile email design.
Design simple templates for small screens.
Although smartphone screen size seems to be increasing with every model release, smartphone screens are much smaller compared with a laptop or netbook, let alone a standard desktop computer. With this in mind, design templates for smart phones that utilize a single column with large buttons and action-oriented, concise messaging.
Use big buttons and white space for easy pressing.
Nothing is worse than navigating a website that hasn’t been optimized for your smartphone. The same can be said for an email. In the past, large buttons have been more about grabbing the user’s attention than anything else. Now, larger buttons are also good for larger hands and fingers—especially because pinching and squeezing your smartphone screen doesn’t always work on some mobile email platforms. So, develop large buttons that are spaced apart from one another, allowing for clear and easy pressing; even if you aren’t using buttons, put ample space between all clickable items. Not only will your templates look nice on someone’s mobile device, but the user might actually click on the links.
Write concise, action-oriented messages.
Let’s be honest. When we’re checking email on our smartphones, we’re often multitasking and therefore distracted. When designing email templates for smartphones, leave out all unnecessary content including both text and images. Doing so will streamline your message and also save on battery usage and loading time. While this has always been a best practice for email marketers, it’s only becoming more important now that more people are using smaller devices for viewing content.
Minimize horizontal scrolling.
Many people use their smartphone to “triage” emails or decide which emails to read later on. Include the most important information and action items “above the fold,” so the user doesn’t have to scroll to find it. Develop smaller headers and make sure the important stuff is close to the top. With that said, don’t worry if you have a lot of content. Vertical scrolling on a mobile device is very easy, and most users tend to expect it. The key is avoiding horizontal scrolling.
Text-only versions are still needed.
Although more people have smartphones, some users may still prefer to receive text-based emails, whether they are on their mobile device or desktop. While mobile devices are getting better at displaying flashy HTML email templates, text-only emails are fast loading and easy to skim through—if you aren’t writing an essay in your copy, which for your subscribers’ sake, you shouldn’t.
Cross-promote email and social media.
Alone, email marketing won’t get you much traction anymore. Social media are here to stay, but that doesn’t mean it’s a replacement for email marketing. While you’re taking the time to examine your email marketing from a mobile perspective, it’s good to remember that social media’s main platform is also mobile. Therefore, don’t be shy about promoting your social media presence in your mobile email templates. And, of course, the same can be said about letting your Twitter followers know that they can get mobile-friendly updates via email as well.
Determine your best send times.
Marketers constantly debate the best times to send emails to subscribers. Naturally, it depends on who your audience is more than anything. Nevertheless, if you’re going completely mobile with your email marketing efforts, think about when your audience tends to use their mobile devices the most. You may find Monday mornings no longer reign as the peak time for open rates.
Never stop learning the latest trends.
Obviously, there is a lot more you can do to optimize your email marketing for the mobile landscape. As mobile devices evolve over time, there certainly will be obstacles to overcome in the future. Regardless, it’s important to learn the trends and look at things from the consumer’s perspective. Take out your mobile device or smartphone and view your email and ask yourself some questions. What do you like? What’s difficult from a usability standpoint? What would make it easier? You may be surprised about what you discover about your own email preferences and habits, which will only provide more insight into your own marketing efforts.
Do you have any mobile-friendly advice for email marketing?