On 2/8/2021 10:52 PM, Nicolas Iooss wrote: > On Mon, Feb 8, 2021 at 10:38 PM Casey Schaufler <casey at schaufler-ca.com> wrote: >> On 2/8/2021 12:35 PM, Nicolas Iooss wrote: >>> Hello, >>> >>> Recently there was a bug in Arch Linux where SELinux was no longer >>> enabled after booting [1], because the default kernel configuration >>> changed recently [2]: >>> >>> ->> +> Neither of these settings will enable SELinux by default. >> >>> By doing so, setting "security=selinux" on the kernel command line >>> seemed to break the system, because reading /proc/$PID/attr/current >>> resulted in "Invalid argument" errors. >> Is this in addition to an "lsm=" specification on the command line? > My description of the issue was not very clear, my apologies. Here is > another tentative. > > For some years, Arch Linux developers have been compiling their > official kernel ( ; >) > with CONFIG_SECURITY_SELINUX=y even though SELinux was disabled by > default. That would imply you do not have CONFIG_DEFAULT_SECURITY_SELINUX=y That's completely reasonable. > In order to use SELinux, users were required to install some > packages (such as systemd with SELinux support) and to add "selinux=1 > security=selinux" to their kernel command line. Sensible. > Last week, the > official Arch Linux kernel was updated to use >>> with "lsm=selinux,lockdown,yama,bpf" fixed the issue and everything is >>> now fine, but now I am wondering: how should CONFIG_LSM (and option >>> "lsm" on the kernel command line) be set, on a system which is using >>> SELinux? >> CONFIG_SECURITY_SELINUX=y >> CONFIG_DEFAULT_SECURITY_SELINUX=y >>> >>> Such information is lacking from the documentation [3] [4]. Therefore >>> I took a look at Fedora [5] and RHEL [6]: >>> >>> * Fedora uses>> >>> Is "lsm=selinux,lockdown,yama,bpf" really problematic? >> The documentation is out of date regarding the "major" module >> having to be last. That was true before the lsm= option was introduced. >> >>> TL;DR: It would be very helpful if there were some clear guidelines >>> which were documented in the kernel documentation about how to >>> configure CONFIG_LSM on SELinux systems. >> Thanks for the feedback. We are at a mid-point in the development of >> module stacking. It's not too late to make things better based on your >> experience. > Thanks for your quick reply! Anyway it seems that my issue was caused > by an incompatibility between selinux and bpf LSM. On my test system > (running Linux 5.10.11): > > * Using "lsm=selinux,lockdown,yama,bpf" works (SELinux is functional, > the system boots fine) > * Using "lsm=lockdown,yama,selinux,bpf" works too > * Using "lsm=lockdown,yama,bpf,selinux" does not work > (/proc/$PID/attr/current raises "Invalid argument") You can't (currently) use SELinux and BPF at the same time. This is because the infrastructure does not support multiple secid<->secctx translation hooks. You get the first one in the list. BPF provides all hooks, so the SELinux hooks aren't reached and the secid to secctx translation fails in the "bpf,selinux" case. The "selinux,bpf" case appears to work, but the BPF hook for security_secid_to_secctx() will never get called. This may be acceptable for your use case. Patches to allow for multiple callers of these hooks are under review. > So it is important that "selinux" comes before "bpf" in CONFIG_LSM > (and "lsm" parameter). This fact seems to be known, as "bpf" was added > last in the default values of CONFIG_LSM options > (). > Is this documented somewhere? It is neither in > nor >. > > Nicolas > >>> Thanks, >>> Nicolas >>> >>> [1] >>> [2] >>> [3] >>> [4] >>> [5] >>> [6] >>> [7] commit >>>