Paul Wade explores the city's 1000-year-old imperial history and extraordinary Gothic architecture.
Many travellers approach Reims as an excuse for a quick tour of a champagne house, a cracking meal and the purchase of a case or two of bubbles. But that would mean ignoring some of France's most important heritage, from its pure Gothic cathedral to fine museums.
"If you only see one French cathedral, it has to be Notre-Dame de Reims," says our guide, Francoise Buckley. "The facade is unique." Looking up at the hundreds of statues on the cathedral's west front, it's hard to disagree.
She points out the city's emblem, a 13th-century figure known as L'Ange au Sourire. "As a child, I asked why the angel had such a happy smile," Buckley says. "'Because it's been drinking champagne,' was the reply!"
You could fit a rugby field into the Gothic nave; the dazzling stained glass ranges from a 13th-century rose window and Chagall's 20th-century designs to the bold reds, blues and yellows that were installed for the cathedral's 800th anniversary last year.
But what makes Reims special for the French is the royal connection: 33 kings were crowned here, most famously Charles VII.
Next door, in the Palais du Tau (the cathedral museum), we see larger-than-life statues of sovereigns and peer at the grandiose robes worn by Charles X, the last king crowned here in 1825. Our royal history lesson continues in the Saint-Remi Basilica. Simple and serene, the 1000-year-old church is named after the bishop, who baptised Clovis in 496. This barbarian-turned-Christian became the first king of the Franks, an empire that metamorphosed into France. The basilica, too, has its own museum.
All four sites have UNESCO World Heritage status. The region has applied for a fifth, for Champagne. At Taittinger, 3 million bottles sit in the former wine cellars of a 13th-century church. "It takes a remueur 10 seconds to rotate 60 bottles one eighth of a turn," our guide said, as we pass racks of upside-down bottles. Even more lie deeper, 20 metres underground in galleries cut out of the chalk by the Romans.
A more visible Roman legacy is above ground: the massive Porte de Mars, with its three stone arches. But there is so much more to discover.
In the church of St Jacques, Romanesque, Gothic and Renaissance styles rub shoulders. The city's art gallery might look like a prison, but it has superb watercolour portraits by Cranach the Elder and 20 paintings by Corot. In a half-timbered town house, Le Vergeur Museum has a collection of woodcuts by Durer.
After most of Reims was flattened in World War I, it was rebuilt in a potpourri of styles, particularly art deco. Recent additions include a new tramway and pedestrianised streets. Soon, the renovated covered market will reopen in the fashionable Boulingrin quartier.
More sober is the Surrender Museum. Here, on May 7, 1945, the Germans signed documents that ended the conflict in Europe. The museum opened a few weeks later.
"For 1500 years, we have been on the frontline," we're told. "That's why Reims has a special place in French history."
FAST FACTS
Getting there
From Paris-Charles de Gaulle Airport, Reims is 30 minutes by train.
Touring there
If you have a head for heights, climb the 249 steps on a guided tour of the cathedral towers. Visit in the late afternoon when the sun lights up the rose window. The cathedral's new son et lumiere is the city's best free show in May-September.
The Reims City Card includes a champagne-house visit, tasting and a choice of two audio-guide tours; €16 ($20).
The best excursion is to drive the 70-kilometre Montagne de Reims Champagne Route; see champagne-ardenne-tourism.co.uk.
Buy bubbly from Paul Dethune, an independent maker in Ambonnay (by appointment, email info@champagne-dethune.com). Buy chocolate champagne "corks" filled with Marc de Champagne from Deleans, 20 rue Ceres. And traditional pain d'epice (gingerbread) at the patisserie L'Atelier d'Eric, 32 rue de Mars.
Attractions closed on Monday: Le Vergeur Museum, Palais de Tau and Carnegie Library. Closed on Tuesday: Surrender Museum, Beaux-Arts.
Staying there
Les Telliers is a small, central bed and breakfast. Double rooms from €87; see telliers.fr.
Hotel de la Paix is practical, refurbished, and in the heart of town. Double rooms from €170; see bestwestern-lapaix-reims.com.
Domaine Les Crayeres near Pommery has 20 sumptuous bedrooms and a two-Michelin-starred restaurant. Double rooms from €360; see lescrayeres.com.
Eating there
L'Epicerie au Bon Manger is a deli with three tables. Ask about the organic champagnes; 7 rue Courmeaux.
Cafe du Palais is a '30s bistro with art on the walls and regional dishes on the plate. 14 place Myron Herrick; see cafedupalais.fr.
Hall Place is a hip bar-restaurant-shop. 23 rue de Mars; see hallplace.fr.
L'Alambic serves stylish modern French cooking in a chic cellar. 63 bis, rue de Chativesle; see restaurant-lalambic.fr.
At Version Originale Christophe Mertes gives classic French dishes an international twist. 25 bis, rue du Temple; see vo-reims.fr.
- The Telegraph, London