In the view of a central banker, the worst thing about skyrocketing food and energy prices is not their rise, but that most people think higher prices are here to stay.
Both the European Central Bank and the Federal Reserve are concerned that a psychology of inflation is setting in — that consumers expect the long run of rising prices, something not seen since the 1970s, to continue.
Current rates of inflation are 3.7 percent in the year through May in Europe and 4.2 percent in the United States. If investors, executives and workers decide that the higher rates will remain, they will begin to bid up prices, wages and interest rates for the day-to-day lending that lubricates the economy.
“They can’t change current prices,” Jacques Cailloux, chief European economist at Royal Bank of Scotland in London, said of the central bankers. “What they are pretty convinced that they can do is dampen inflation expectations.”
The European bank appears to be taking the lead in fighting the trend, and is likely to raise interest rates next week despite reports on Monday showing that growth prospects in Europe had slowed further. The Fed has also signaled that it will consider raising rates after cutting them as the American economy headed into a slowdown.
For much of the last year, central banks have played a wait-and-see game, betting that commodity prices, particularly oil, could rise sharply without setting off price increases.
But airlines have imposed fuel surcharges on tickets as oil neared the $140-a-barrel level.
And companies that use crude oil as a raw material, like the giant multinational company Dow Chemical , have raised prices.
In Europe, unions, riled by the impact of high fuel prices on members’ pocketbooks, are asking for higher wages, a cost that could be passed on to consumers. Because unions are much stronger in Europe than in the United States, the trend distinguishes the task of the European bank from that of the Fed, where worries are dominated by an economy flirting with recession.
Lufthansa’s employees are demanding a 9.8 percent increase in wages. In Britain, though it is not a part of the euro area, 600,000 British government workers voted Monday to strike over contract offers that did not reflect the rising cost of living.
After the experience of the 1970s, in which inflation seemed to spin out of control, central banks searched for early warning indicators that would signal when an inflationary psychology was taking hold.
Economists responded with data intended to show what people were thinking.
One measure is the premium that bond investors demand to compensate for the risk of inflation over the life of the security. In Europe, markets have embedded an inflation premium in 10-year bonds.
That premium has risen in recent months to 2.5 percent, the highest level since the birth of the euro in 1999, according to Barclays, and above the central bank’s inflation goal of less than 2 percent.
In the United States, the picture has been similar, with bond market indicators edging notably higher.
A survey closely watched by the Fed, a University of Michigan poll of consumers, showed that inflation expectations in May rose to the highest level since February 1982.
The European bank president, Jean-Claude Trichet, cited inflation expectations as the main reason the bank would probably raise rates at its meeting July 3.
“We have to be credible in this delivery of price stability,” Mr. Trichet said, “and that is the reason why we insist so strongly on inflationary expectations remaining well anchored.”
Mr. Trichet hinted at one rate increase, by a quarter of a percentage point, to 4.25 percent, in July. Other officials have since damped speculation of a series of increases, and the European bank appears to be betting on a kind of psychological shock to financial markets — a slap in the face to warn of more if inflation expectations do not subside.
“What you want to do right now is short-circuit the transmission of these prices increases into future increases,” Mr. Cailloux, the bank economist, said.
The shift in tone in Europe may already be having an effect in the United States, analysts said. With financial markets so tightly integrated, the expectations of higher inflation move quickly between the two continents. That is pressuring the Fed to confront the issue despite a slowdown.
Members of the Federal Reserve Bank “are being pulled along in this process,” said Ethan Harris, chief United States economist with Lehman Brothers in New York. “I think they are reluctant to raise interest rates, but it is hard with such hawkish rhetoric from the E.C.B. and other Fed officials.”
When Mr. Trichet talked about raising borrowing costs in early June, the euro strengthened. That pushed the dollar lower just as the Fed chairman, Ben S. Bernanke, and the Treasury secretary, Henry M. Paulson Jr., appeared to reverse their long-standing tolerance of a weak dollar, which had helped prop up American exports.
A slowing American economy can curb inflation as mounting job losses cut overall demand and limit companies’ ability to raise prices. But if that does not cool inflation, the Fed will be in a bind.