Imagine standing in the Gobi Desert with no life as far as the eye can see. A cloudless sky beating the sun’s rays down. You’ve been there for six weeks without a drop of water. But you are still there. This is reality for the Deinococcus species of extremophiles. These robust bacteria have evolved to cope with the harshest environments found on our planet. Since its discovery in 1956, coincidentally 56 years ago, scientists have been trying to understand the mechanisms behind these adaptations at a molecular level. Their hard work is now paying off in new and exciting ways.
Much of the recent research links back to why this species of tough microorganism was discovered. Back in the 50s, a new method of preserving food using gamma radiation resulted in a tin of spoiled meat and Deinococcales radiodurans was found to be the culprit. Exposure to unnaturally high doses of ionizing radiation was a doddle to this new species with 90% survival rate at a dose of 5,000Gy. To put this in perspective, workers at the Chernobyl plant were exposed to a cumulative dose of about 0.1Gy* during the 2-year clean-up process.
There is nowhere on earth with such high natural radiation so the first puzzle was why these bacteria had adapted to survive. Martian theories involving meteorites were thrown into the mix. Scientists tested the bacteria with natural extremes including lack of water and UV radiation. They flourished and were soon discovered in places like the Sahara (D. deserti), geothermal vents (D. geothermalis) and the Gobi Desert (D. gobiensis).
What confers these unearthly properties on the adeptly nicknamed Conan the Bacterium? One hypothesis is that the high dose of radiation is inadvertently turning the bacteria into super-mutants. This is correct in once sense as it is mutating the bacteria’s DNA. Since other bacteria e.g. E. coli do not succumb to a blessing of extra strength, we have to look beyond the supernatural for an answer.
The first point of call was DNA damage as high doses of radiation are notorious for causing double stranded breaks in DNA. D. radiodurans DNA is broken in a similar fashion to other bacteria but its supremacy is the ability to repair this damage. Recent research has addressed this by focusing on a very damaging process, oxidation. Radiation and other environmental stresses increase the release of damaging reactive oxygen species. These are a natural byproduct of metabolism but when they are increased dramatically they cause damage to cell structures. The power of the super-bacteria is their ability to prevent this devastating destruction.
Anti-oxidants are a vital component in this process and a number of studies have shown a particular detox ion is present in higher volumes in D. radiodurans under stress. The manganeseII ion is a cofactor in many enzymes and its action permits resistance to extreme conditions. Scientists have revealed these hardy bacteria have a very efficient manganese regulatory mechanism. Deinococcus species have taken the use of antioxidants to a new level!
Having revealed many of these extremophiles secrets, scientists have discovered some novel ways of exploiting its properties. IrrE is a protein switch and shown to be involved in protecting D. radiodurans. Transferring this regulator to E. coli also transfers the protection. Under conditions which would normally be fatal such as salt and thermal shock, the E. coli survived. Moving to a higher level, IrrE also endowed salt tolerance when tested in a transgenic plant, Brassica napus. These initial experiments give us a glimpse of the potential IrrE could have in transgenic plants as 20% of all land is now affected by salinity.
Telling the story of D. radiodurans reveals a thrilling tale of discovery and potential. This bacteria is more than an entry in the Guinness Book of Records. The mechanisms behind the world’s toughest bacteria reveal elements that could be adapted for use in radioprotection and higher tolerances in crops. More possibilities will be revealed as its means of protection are investigated further. One thing is certain; the Deinococcus species will remain long after we are distant memories and the Gobi Desert is no more.
*Note: According to the World Health Organization, for most exposures from the Chernobyl accident, absorbed doses are similar to effective doses (i.e. 1Gy is approximately equal to 1 Sv).
Chen T, Wang J, Yang R, Li J, Lin M, & Lin Z (2011). Laboratory-evolved mutants of an exogenous global regulator, IrrE from Deinococcus radiodurans, enhance stress tolerances of Escherichia coli. PloS one, 6 (1) PMID: 21267412
Daly MJ, Gaidamakova EK, Matrosova VY, Kiang JG, Fukumoto R, Lee DY, Wehr NB, Viteri GA, Berlett BS, & Levine RL (2010). Small-molecule antioxidant proteome-shields in Deinococcus radiodurans. PloS one, 5 (9) PMID: 20838443
Pan J, Wang J, Zhou Z, Yan Y, Zhang W, Lu W, Ping S, Dai Q, Yuan M, Feng B, Hou X,) PMID: 19204796