Timothy Lyle
Initially, I had planned to compose a blog post structured by hashtags and infused with tweet-able moments about how and why I use social media in the literature classroom. But after careful consideration of recent current events, I have changed my mind—an often frustrating decision that is indicative of a life-long penchant for revision, to be sure.
Because I am teaching my core literature courses around “the dangers of the single story” and “why narrative matters” this semester, I feel compelled to join creative acts of cultural production, intellectual pursuits, and acts of political resistance with the following post.
Last week, North Carolina lighted social media on fire and ignited activist passions for social justice by calling an emergency special session and by hurrying a significant anti-LGBT piece of legislation through both the House and the Senate. Among the many disheartening components of the North Carolina House Bill 2 (known mostly as HB2) is a stipulation that bans transgender individuals from using restrooms and other public facilities that match their gender identities unless they have successfully changed their birth certificates—despite the difficult barriers that prevent them from doing so, if they choose to in the first place.
If you might be thinking that North Carolina’s legislation is an isolated attempt to police gender and rob trans folks of their safety and the dignity to relief themselves in peace, I would encourage you to familiarize yourself with similarly problematic bills circulating in or threatening to emerge from the following states: Kansas, Minnesota, Tennessee, Michigan, and Georgia.
In and out of a variety of states, a troubling tendency persists that captures the attention of an English professor. Not only are trans folks suffering unthinkable levels of everyday discrimination, but they are also subjected to everyone else’s narrativization of their identities and their lived experiences. Throughout media coverage, in legislative halls, and during everyday conversations, trans folks remain subjected to unsubstantiated claims of predatory behavior, pedophilic inclinations, and overall perverse dispositions. Under the guise of a rhetoric of privacy, fueled by steadfast “protection” of the heteronormative/cisnormative nuclear family, and shaped by rigid, binary understandings of gender identity and its relation to an interpretation of genitalia at birth, non-trans individuals regularly direct inaccurate, incomplete, and oppressive narratives of trans identities and experiences.
As a corrective to a host of cisnormative constructions of transgender people, I would like to use this blog space to offer narratives and resources to our readers that self-identified transgender cultural producers shape themselves. In so doing, I encourage you to ask what else comes into view when trans folks become the content creators of their own stories—or at least become key players. How do the very questions that underpin these narratives shift dramatically? Because these severely marginalized individuals rarely have access to mainstream cultural production venues, readers have to search harder to discover their voices, especially the voices of those who reside at the complicated nexus of race, gender, sexuality, and class in America. Below, our blog readers will find a starting point for reorienting themselves or for at least hearing divergent voices often suppressed in favor of intensely dispossessing accounts.
Aspiring cryptologists out there in the blogosphere might quickly notice that my list of 6281969 is a nod to the historic Stonewall riots in our neighboring New York City on June 28, 1969—an act of everyday resistance that is often credited with helping ignite the modern-day LGBT liberation movement. What you might not realize, however, is that narrativizations of this paramount act of issuing a resounding NO! to routine discrimination, disempowerment, and perverse use of authority started when trans women of color, homeless queers, sex workers, and other gender non-conforming people fought back.
Unfortunately, though, with the normalization of the LGBT movement—massaged by a politics of respectability—the contributions and voices of these community icons fade into the background or disappear all together. For a recent concrete example, look no further than the boycotted film Stonewall (2015) directed by Roland Emmerich.
Taking my cue from the soon-to-be-released short film Happy Birthday, Marsha (centering the life of Marsha “Pay It No Mind” Johnson and her contributions to the Stonewall Riots), I am offering a list of 6/2/8/1/9/6/9 to share transgender women of color content creators that you should know in a variety of creative and political circles.
6: Books by Trans Women of Color/Queer People of Color to Read
- Janet Mock, Redefining Realness (2014)
- Ryka Aoki, Seasonal Velocities (2012)
- Lovemme Corazon, Trauma Queen (2013)
- Toni Newman, I Rise: The Transformation of Toni Newman (2012)
- The Lady Chablis, Hiding My Candy (1997)
- Sharon Davis, A Finer Specimen of Womanhood (1985)
2: Blogs by TWOC/QPoC to Surf
- Monica Roberts, The Trans Griot
- (Various), Black Girl Dangerous
8: TWOC/QPoC to Follow on Social Media
- Laverne Cox
- Angelica Ross
- Cherno Biko
- Janet Mock
- Lynn Cyrin
- Reina Gossett
- Geena Rocero
- Brooke Cerda Guzman
1: TWOC/QPoC Organization to Support
- Trans Women of Color Collective
9: Films or New Media Titles by, about, or starring TWOC/QPoC to View
- Tangerine
- Her Story
- Orange is the New Black
- Happy Birthday, Marsha (in post-production)
- Laverne Cox Presents the T Word
- FREE Cece (to be released in 2016)
- MAJOR! (in post-production)
- Mala Mala
- Paris Is Burning
6: TWOC/QPoC Historic Figures to Learn
- Sylvia Rivera
- Marsha P. Johnson
- Miss Major Griffin-Gracy
- Sir Lady Java
- Tanya Walker
- Carlett Brown
9: Things to Avoid Saying to TWOC
- “Have you had the surgery?”
- “You are so passable. I would never know.”
- “______ would really help you to be more feminine or masculine”
- “How do you have sex?”
- “What bathroom do you use?”
- “Can I touch your hair?”
- “That pronoun thing is just too confusing for me.”
- “This reminds me of RuPaul’s Drag Race? I love that show!”
- “So your boyfriend/partner is gay, right?”