Jack B. Yeats, They Love Me, 1950. Oil on board, 35 x 45 cms. Private Collection.
Liebestod: Love and Death
The title of Yeats's unpublished play conjoins sexuality and death – a pairing that Yeats and other writers and theorists have argued is an inherent part of human nature. Love (Eros) and death (Thanatos) – or the erotic drive and the death drive, as Freud identified them – lie at the root of human desire. In Yeats's words, "the desire that is satisfied is not a great desire," because desire itself is determined by the absence or unobtainable quality of the love object. 1 The association of love and death, called Liebestod, takes its name from the final aria in Wagner's opera Tristan und Isolde and assumes a number of forms in literature. As Elizabeth Butler Cullingford explains, the love-death link appears when "the poet loves a dead woman or a deadly woman" or two lovers "die in each other's arms or their love is consummated after death." 2 The Liebestod is consensual, as distinguished from sadism or masochism, in which male eroticism is often stimulated by female victimage. Although the trope in Western poetry has tended to be gender-specific – the male poet desires (the death of) a female partner – the imbalance of power is not as pronounced as it is in other representations of sexuality and death. The emphasis in the Liebestod is on desire – unsatisfied, infinite, continually reproducing – and not on violence; the death is meant only to prolong the bittersweet yearning for the beloved, which if fulfilled, would cease to have as strong a hold over the poet who voices this desire.
Yeats returned to the Liebestod time and again in his poetry and drama, including the early verse plays, linking love and death often as a means of negotiating his unrequited feelings for Maud Gonne. According to Cullingford, Yeats associated sexual passion with annihilation and consoled himself with the thought that Gonne would be accessible to him in death: "The dead woman, unlike the living one, can be imaginatively possessed forever: she is incapable of change or self-assertion. Love poetry, like elegy, frequently feeds on the obliterated subjectivity of the person who occasions it." 3 Cullingford cautions us again reading Yeats's poetry in too narrow a biographical context by linking his use of the Liebestod with his ongoing pursuit of Gonne. Indeed, the frequent association of love and death in Yeats's work is evident even to the casual reader, and it provides a lens for interpreting the early verse drama. Like Percy Bysshe Shelley, whose poetry the young Yeats deliberately imitated, the quest for love in nearly all of Yeats's early plays ends in death – the death of the lover, the death of the beloved, or in the case of Love and Death, the death of everyone on stage in the final scene. This is a pattern that Yeats borrowed from Shelley's Alastor. In George Bornstein's words, "Earthly love alone does not satisfy either the Shelleyan or the Yeatsian lover, who longs for ideal completion." 4 The impossibility of satisfying his (or her) desire leads the lover to accept, even embrace death as a compensation and an escape.
George Frederic Watts, Love and Death, 1897. Oil on canvas, 283 x 150 cm. Tate Britain, London.
This is evident in Love and Death in Ginevra's suicidal pursuit of Sintram, an immortal "Spirit Hunter," whom no human can behold. After witnessing the deaths of her companions in the final scene, Ginevra beseeches her lover to remain with her – to draw closer, although she knows his presence will ensure her own death. Her final words and Yeats's closing stage directions, consistent with the Liebestod, imply that Ginevra is joined with Sintram in death. She pleads, "come we will go / …we will together go," and her death is indicated when the phantom fades. Reversing the gender roles of Yeats's later love lyrics, the play features a woman who is by turns lovesick – occupying the role usually reserved for the male poet – and sinister and murderous. Ginevra exercises control over the men in the play, murdering her father, King Ralph, and thwarting Moscon's attempts to avenge Alice's death. But as if he is threatened by this display of female power, Yeats dramatizes her death, allowing her to narrate the process until the end. Elizabeth Brewer Redwine notes, "Yeats brought this trope into his poems as well, but his love elegies contain only his own speech; the speaker in the poems is the courtier/lover describing the woman's death." 5 The Liebestod works on two levels in the play: first, the female protagonist and her immortal lover presumably consummate their love in death; but on a second level, the playwright dramatizes the death of his heroine, curtailing her power and fixing her in place in a move that parallels the male poet's desired "possession" of his dead female beloved. The conventional balance of power is restored, and in these final lines, we witness perhaps Yeats's earliest exploration of the love-death link.
2. Ibid., 44.
3. Ibid., 46.
4. George Bornstein, Yeats and Shelley (Chicago: University of Chicago Press, 1970), 19.
5. Elizabeth Brewer Redwine, "'She Set Me Writing My First Play': Laura Armstrong and Yeats's Early Drama," Irish University Review 35.2 (Autumn-Winter 2005), 254.