“Green career” is a term that’s popped up as a result of interest in being kind to Mother Nature (not that she doesn’t deserve it). According to CareerOneStop, a green career is any job “affected by activities such as conserving energy, developing alternative energy, reducing pollution, or recycling.”
For a deeper look at green careers, I caught up with Simon Smedberg, co-founder and CEO of Glooby, a travel search engine enabling users to compare flight and hotel prices while highlighting the most fuel-efficient flights and eco-labeled hotels.
More than 1 billion tourists are flying around the globe every year, and that number is increasing. Airplanes emit so much carbon dioxide, it’s important to be conscious and make changes where we can.
Today there’s a growing awareness of the challenges facing our planet, and this is increasing the supply of green goods and services. With inspiration from the car industry (think Tesla) and the food industry (like properly eco-labeled products), we started Glooby. We wanted to create a travel site that, aside from having the cheapest prices, also made it easier for people to find the eco-friendliest alternatives.
Sustainability touches virtually all sectors of society: food, energy, transport, education, government — you name it. But since the term “green career” is relatively new, not everyone understands what it is, leading to an information deficit. Therefore, an obstacle for me has been to learn everything about the travel industry and the environmental problems it faces. After that, I need to teach others why it’s important and how we can solve it.
Some green careers also require specific skills or education, such as a solar or wind engineer. I’m confident, though, that higher demand for green goods and services will provide new job opportunities as a result.
You contribute to a more sustainable world. And, these jobs are difficult to outsource. Reducing our dependence on oil will involve work, and that means job security. To make our economy greener we have to change the places we live, work and transport ourselves. Making buildings more energy efficient, installing solar panels and wind turbines, cultivating and refine biofuels, etc — it’s all work that must be done in that location.
It’s a growing industry. There are people who understand that travel has a big impact on our environment and are looking for ways to reduce it. Some consumers are successfully rewarding businesses for their green development by minimizing their carbon emissions.
In the past, companies have focused partly on sustainability, but also made products and services so poorly in comparison to the less-green competition that they’ve put a negative mark on the industry. This is something we’ve been working to change. Many people unfortunately associate sustainability with expensive and uncomfortable — and that’s not true. Therefore, we’re trying to create something that is not only environmentally friendly, but the best. An example would be Tesla, which, in addition to being environmentally friendly, also builds one of the fastest cars on the market.
That they’re only for researchers, scientists and environmentalists. But there are many industry jobs relevant to the green economy, like Glooby. We convey trips like other travel sites; however, we also strive to spread awareness in the protection and conservation of our environment.
Environmental awareness and efficiency will characterize all industries. Businesses need to respond to the growing development we see today. Some simple steps to do this are to:
Also, analyze your biggest impact on the environment. With Glooby we recognized ours was energy use for website hosting. That’s why we use green web hosting from Rackspace, whose data centers are powered on 100-percent certified renewable energy.
Greenwashing is a big problem in the industry. Companies engaged in this affect not only themselves negatively, but also reduce consumer confidence in green goods and services. It is very important that certifications are very clear — which not all are — with their requirements.
Eco-labels need to be tough and carefully monitor every company or product they certify. This affects the entire industry. There are so many different eco-labels out there, which we noticed when collecting eco-labels for the hotels on our website. We had to determine which eco-label adopted the best principles to benefit the most ambitious hotels. Therefore, we’re pleased that there is an organization in the sustainable tourism — GSTC — which evaluated and approves various eco-labels.
Stricter labels help reduce the risk of greenwashing, but we’re not totally there yet. For example, there are many different eco-friendly labels in the food industry. Smedberg has seen eco-labeled blueberries that were picked in Sweden, worked on in Poland and packaged in Holland before finally ending up on the store shelves in Sweden. This product does not deserve an eco-label.