LONDON, Sept 29 (Reuters) - Unemployment in the world's biggest developed economies has been falling, at least since the end of the financial crisis. But wages, in the main, have not reacted as might be expected.
They have generally either grown only modestly, or even fallen.
Take, for example, resurgent Germany. Since 2012, the unemployment rate has tumbled to the lowest level since reunification. Wages and salaries have grown -- but only gradually and at nothing like a rate to imply pressure.
It is even clearer in Japan, where unemployment this year has fallen to a more than 20-year low of just 2.8 percent
"Everything tells us the labour market is tight in Japan," said Mark Williams, chief Asia economist at Capital Economics. "(But) the one place we are not seeing labour market tightness in is wages, which aren't rising at all."
One impact of this globally is that inflation has not picked up much despite the massive amount of stimulus hurled at it by central banks, including negligible or even negative interest rates. Indeed, it may be one reason why some banks appear to be less worried about low inflation than they were.
For the worker, the lack of inflation has masked some of the wage stagnation. (It has only become a hot issue in Britain, for example, since inflation took off after the Brexit vote.)
But this may not last. September's GfK sentiment index suggested German consumer morale may be about to cool as a result of a more negative expectation for incomes.
The more-workers-less-pay-growth phenomenon, meanwhile, is the subject of a new report from International Monetary Fund economists Gee Hee Hong, Zsoka Koczan, Weicheng Lian and Malhar Nabar.
They find the disconnect between unemployment and wages to be the result of a number of factors -- including the slowdown of productivity -- that are relatively new and which are probably not going to go away.
A key factor is an abundant workforce -- labour market slack in the jargon. But that is a seeming contradiction given the record low unemployment rates in some places.
It comes down to people working fewer hours than they would like and the trend towards temporary contracts -- the gig economy, zero-hours contracts and so on.
That leaves a large number of workers for companies to choose from if wage demands rise.
"Despite employment growth, hours per worker have continued to decline and involuntary part-time employment has increased in more than two-thirds of countries," the IMF report notes.
A second factor is, in effect, the impact of globalisation and a more integrated global economy.
Local labour slack is essentially only part of the picture.
"(Playing a possible role are) the threat of plant relocation across borders, or an increase in the effective worldwide supply of labour," the economists found.
Interestingly, a third factor -- automation -- was not found by the IMF team to have had a major impact, at least yet.
That may come later. In March, PwC consultants estimated that by 2030 automation will impact -- do away with or change -- 38 percent of existing jobs in the United States, 35 percent in Germany, 30 in Britain, and 21 in Japan.
Sounds a long time away, but it is just over 12 years.
ITALY NEXT
The political impact of all this is unknown -- although Britain's Brexit vote, the election of U.S. President Donald Trump, and the rise of the far-right AfD in Germany all point at the very least to voter disenchantment with the status quo.
So the next big test could be Italy, where unemployment is a stubborn 11.4 percent and wage growth has been running at negligible year-on-year rates. Italy will have to hold a general election by the end of May next year and an economy deemed to be weak or unequal could boost support for parties that at the very least have been critical of the euro.
Among them are the 5-Star Movement, the Northern League and even former prime minister Silvio Berlusconi's Forza Italia. Berlusconi recently raised the idea of a parallel currency to the euro.
The coming week will give a snapshot of Italy's economy, with September's purchasing manager indexes (PMI) and the unemployment rate for August. There will also be retail sales data -- sometimes a test of voter contentment.
Meanwhile, there will be a global economic snapshot for the end of the third quarter, from PMI across the globe to U.S. payrolls. (Reporting by Jeremy Gaunt; Editing by Catherine Evans)