After 17 years, researchers using the Parkes radio telescope in Australia have identified the culprit behind a mysterious type of radio signal: two on-site microwave ovens.
The 64-meter Parkes radio telescope in Australia is usually silent. Astronomers control the radio dish, slewing it from horizon to horizon, from off-site locations. Occasional staff workers might meander through the halls during the day. But otherwise, the facility is as quiet as the universe it observes.
But on one particular day in mid-March, the facility was bustling with activity. Astronomers weren’t, however, huddled around the radio dish. They were gathered around a microwave oven in the facility’s kitchen. The observers were continuously heating and re-heating a cup of water in order to test the microwave’s effect — if any — on the colossal dish nearby.
The reason dates back 17 years, when astronomers first spotted fleeting bursts of radio signals in their data..
The fact that perytons only appeared in data gathered by the Parkes telescope also suggested the source was local. But the team didn’t know just how local perytons might be. Theories about the signals’ origins included lightning, satellites, and any of the various electronics on site. “There are many potential offenders,” says Sarah Burke-Spolaor (National Radio Astronomy Observatory). “We just had no clear idea where to start testing.”
Then Petroff, Burke-Spolaor, and their colleagues installed a real-time radio interference monitor late last year. In January, the telescope detected three of the signals and the interference monitor also picked up three signals at 2.3 to 2.5 GHz, the same frequency range that a microwave oven runs on.
So on that fateful day in March, the astronomers found themselves continually testing and re-testing a nearby microwave oven. Still, they couldn’t re-create a peryton. But when they opened the oven’s door prematurely, the signal appeared. They had unleashed a small but powerful radio signal.
The perytons were likely caused by staff members who were too impatient to wait for their lunches to finish heating. “We were quite surprised about this,” says Petroff. “It turned out to be something so simple and so close! It felt pretty good to solve the mystery.”
With One Mystery Solved, Another Unfolds
Sensitive radio telescopes, like the one at Parkes, can easily detect rogue radio signals. And human interference is a common frustration for radio astronomers. In the telescope’s early days, Burke-Spolaor often found herself observing poor data only to find that someone at the visitor’s center was on his cell phone or the bathroom’s toilets were continuously flushing.
Recently, astronomers even voiced concerns over a plan to design robotic lawn mowers that would run on radio waves.
The perytons in particular interfered with this team’s main mission: to understand the source of fast radio bursts, brief but brilliant signals with potential extragalactic origins. Both perytons and fast radio bursts have a distinct look to them, in that their lower frequencies arrive noticeably later than their higher ones.
Typically, this dispersion is created when light travels through dense clouds of electrons in extragalactic space. Lower frequencies (longer wavelengths) of radio emission interact more with the electrons than higher frequencies do, and so the lower frequencies end up delayed, like an extrovert trying to leave a party. The higher the time delay, the further the signal has traveled. Most astronomers think fast radio bursts originate as far as 10 billion light-years away.
But seeing a terrestrial signal exhibit this same effect worried astronomers. It didn’t help that the first fast radio burst discovered had a nearly identical time delay to the perytons.
Astronomers now know of several fast radio bursts, and they’re certain that perytons and bursts are two different phenomena. Not only do perytons always exhibit the same time delay (one typical of a microwave oven), but they also tend to cluster around lunchtime, says Petroff. Fast radio bursts, on the other hand, occur at random, with a range of time delays because they’re coming from a range of cosmic distances.
With the mystery settled, Petroff and her colleagues can focus on the origins of fast radio bursts. It’s still unclear how these enigmatic bursts are created — perhaps when an incredibly fast-spinning magnetar throws off flares, or two dense neutron stars collide. Either way, it’s likely to be far more exciting than a microwave oven.
Reference:
Emily Petroff et al. “Identifying the Source of Perytons at the Parkes Observatory.” Posted to arXiv.org April 9, 2015.
Wasn’t this an episode on “The Simpsons”? The one where Homer won the Nobel Prize, but while he was making his acceptance speech in Oslo Lisa interrupted and explained that the remarkable finding was really just because he had opened the door of the microwave while nuking a bratwurst?
Being an engineer, never trusted the interlock. Always made sure oven off before opening.
I bet the effect occurred in the few milliseconds between the door opening and the magnetron bleeding off any stored energy, including in the power supply. The interlock worked fine, and no real safety hazard occurred.
I was working on the integration and test of an airport radar in Waterloo, Ontario in 1994. We started observing “rabbit tracks” – evidence of pulsed interference, usually from another radar operating in the same band – on the PPI (radar scope). We tracked it down to testing of one kilowatt transmitter modules operating in the same band as the victim radar in the same facility as the radar. The modules were terminated by a resistive load, inside an improvised screen room – two by fours with copper screening tacked onto them. The isolation level was about 170 dB (17 orders of magnitude) between the units being tested and the radar receiver. I doubt that the copper screen was actually contributing much isolation. The source was in the diffraction near field (Fresnel region), which was probably the case here as well. In our case the interference was harmless. We could tell when the testers were at lunch or on break. We could ask for radio silence if we were performing tests where a customer witness might be upset, or it actually made a difference. The only effect of such small interference was a very slight desensitization of the radar, the difference between seeing in astronomical twilight and total darkness.
I agree with James De Camp. In my opinion, this experiment shows two things:
1. The radio telescope is a very sensitive test to prove that microwave ovens in good condition do not radiate hazardous energy as many urban myths believe;
2. Definitely it is a bad practice to open the microwave oven suddenly without waiting for it to stop. For sure you are getting bathed in radiation!