The Melbourne Conservatorium of Music will celebrate the activities of music rehearsal and practice and is set to be the ‘green room’ of Melbourne’s arts precinct.
Outwardly focused and inviting, the eight-floor $105 million MCM at 33 Sturt Street aims to balance the singular concentration required of students with the camaraderie of engaging with others. The building makes a place to rub shoulders with fellow music students, and the artistic milieu of the wider campus and precinct.
The site, currently a car park, is leased from the Victorian government, which has also provided a $3-million grant to the project. The Labor Government is contributing the land under a long-term lease arrangement.
Covering a site area of 5,100sqm, project lead John Wardle Architects have been joined by landscape architects Aspect Studios in conceiving a site-specific response, with the aim of encouraging activity across the site and the wider area..
Dodds Street has been earmarked by the City Of Melbourne as a prime candidate for conversion to a pedestrian thoroughfare, providing Southbank with additional public space.
The activity of the students within the new building are brought to the street and campus with choreographed views that are revealed as building corners unfold or a window allows for a privileged aspect upon the process of rehearsal. In this way, a conversation emerges between the curious passerby and the rehearsing musician, encouraging interaction between the musician and their community.
The design also includes a public square or pocket park, which will contribute to a community space plan outlined in the Melbourne Arts Precinct Blueprint. The blueprint, released by Arts Victoria in February 2014, found the precinct lacked street life and was dominated by “inward-looking institutions” and “inactive street frontages.”
The building will include a 443-seat cantilevering auditorium, a 200-seat ground-floor studio and a range of rehearsal studios and spaces for teaching, performing, recording and research. It has been designed to be the “inverse” of the current MCM facility on Royal Parade at the University of Melbourne’s Parkville campus.
Multiple vantage points in the new MCM allow for appreciating the inner workings of music education. The learning and rehearsal spaces, both small and large, are interspersed with bell-shaped portholes, hinged panels and disguised windows that generously exhibit the activity within. A large oculus window into the ground floor orchestral rehearsal space unlocks the traditional vault of music education to reveal its inner realm.
Unlike The Enraged Musician, Willliam Hogarth’s 1741 depiction of a conflict between a musician in the parlour of his private home and urbanites whose home is the street, the new MCM encourages curiosity and interaction between the musician and their community.
John Wardle Architects won the design competition for the University of Melbourne’s $105 million project in July 2016.
Construction is slated to begin in 2017, with first classes expected to commence in the building in 2019
Key Themes of the Melbourne Arts Precinct Blueprint
According to documents, the MCM’s design is in part based upon four key themes held within the wider ranging Melbourne Arts Precinct Blueprint including;
- Bring life to the streets
- Create a ‘Melbourne’ experience
- More to see and do
- Make connections
Further, the following design principles have been instilled within the MCM design:
- Green Spine: Green infrastructure such as semi-advanced tree planting and water sensitive urban design. Rain gardens will tie the open space together as a green spine
- Landscape Structure: The East and West ends of the open space will be designed as urban anchors. Materials and landscape form will be responsive to the design and/or strategic objectives of Sturt Street and Dodds Street
- Landscape Character: The open space will be comprised of three segments responding uniquely to their surrounding context such as street and buildings interface
- Intimate Spaces: Provide a series of small-scale spaces that provide comfortable locations for individual comfortable spaces for day to day use such as lunch, having coffee, studying and reading
- Performance Fields: The design will incorporate a level of spatial flexibility
- Pedestrian Movement: The open space will provide a strong connection between Sturt Street and Dodds Street for pedestrians. Secondary linkages into the adjacent VCA campus will provided. The plans for building 877 will provide a future food or beverage outlet and bicycle storage
- Frontages & Sight Lines: The interfaces with both Sturt Street and Dodds Street will have considered design responds. Critically the interface with Dodds Street will be designed in coordination with the City of Melbourne
The Campus
The new Conservatorium building forms part of an ongoing redevelopment of the University of Melbourne’s Southbank campus.
In 2014, the VCA & MCM’s Grant Street Theatre was refurbished and the new Lionel Gell Lounge launched, creating one of Melbourne’s premier music theatre performance venues.
The Dodds St Stables Redevelopment, worth more than $40 million, will redevelop the Dodds Street stables into a visual arts wing at Southbank, creating a new entry point to the University and opening the campus to students, local business and residents. The stables project is planned to be completed by April 2017.
Other Entries and Concepts
For its competition entry, Hassell turned the traditional, internalised approach to arts venue design on its head – stripping away the walls and showcasing the activity within.
By scooping out the façade of the main street frontage, the school is a dramatic, yet welcoming presence in the precinct. Translucent and transparent surfaces make the teaching, rehearsal and performance spaces visible from the street and accessible from within – inviting interaction from those passing by or through the building.
The interior spaces are positioned around a central atrium, which brings in an abundance of light, views and fresh air. Many of these spaces are separated from the atrium only by glass. Like the facade, this reveals activities such as intense rehearsals or casual jamming taking place throughout the building.
Winning renderings: John Wardle Architects
Other images: Hassell