Social matters: Mice missing PSD-95 are friendlier than controls, but also have some autism-like features.
Mice missing a large protein at the junction between neurons show motor impairments, anxiety and increased social behaviors — all features reminiscent of Williams syndrome, a rare developmental disorder. The findings appear online 15 October in the American Journal of Psychiatry1.
The protein, postsynaptic density-95 (PSD-95), sits on the receiving end of a neuronal connection, or synapse. It is part of a key molecular bridge connecting other synaptic proteins — such as SHANK, neuroligins and neurexins — that have been linked to autism and related conditions.
"[The study] bolsters this notion of [the synapse] being at the basis of many kinds of neuropsychiatric disorders," notes Nils Brose, professor of biochemistry at the Max Planck Institute for Experimental Medicine in Göttingen, Germany, who was not involved with the study. "Synapses are the brain's main information processors: as they are perturbed, things go wrong."
Williams syndrome is characterized by mental retardation and a cheerful disposition, and is caused by the deletion of about 25 genes on chromosome 7.
The mutant animals lack DLG4, which codes for PSD-95 and is located on chromosome 17. Intriguingly, this loss seems to somehow affect the genes causing Williams syndrome: the animals express about 50 percent lower levels of CYLN2, a gene in the Williams syndrome region, in the brain compared with controls.
PSD-95 is known to shuttle several types of molecules to the synapse and, once they're in the right place, anchor them there securely. This positioning can have huge effects on how the synapse works.
For example, the first study of a PSD-95 mutant mouse — published by Seth Grant's team in 1998 in Nature — found that the animals have trouble learning spatial routes and have abnormally strong synapses in the hippocampus, a region important for memory2.
In the new report, Grant and colleagues investigate the social, communicative and motor behaviors of mice lacking PSD-95.
Because of the well-known ties between synaptic proteins and autism, the researchers expected the mutant mice to have autism-like features, and they do have some. For example, they repeatedly explore the same arm in a maze, echoing one of autism's core symptoms.
Male mutants produce fewer vocalizations in the presence of females than controls do, which could be akin to the communication deficits central to the disorder. Mutants also have poor balance and an unusual gait — motor problems that are sometimes seen in individuals with autism.
The social interactions of the PSD-95 mutants, however, are decidedly unlike those seen in autism. Presented with a choice between exploring a room with an empty cage in it or a room with a cage holding a mouse inside, the mutants choose the room with the playmate. In fact, they spend even more time with the new mouse than do controls.
"This just blew us away," says lead investigator Andrew Holmes, chief of behavioral science and genetics at the National Institute on Alcohol Abuse and Alcoholism. "Not only were they not spending more time with the object, as you would expect from an autism model, but they were strongly preferring the social stimulus."
Researchers have no good answers for why the loss of some synaptic proteins, such as neuroligins and neurexins, leads to a decrease in social behaviors, whereas losing PSD-95 apparently has the opposite effect.
Brose notes that sorting out these mechanisms is particularly problematic when a mutant animal shows a complex mix of behaviors. The PSD-95 mutants from the 1998 study, for instance, have some memory deficits. If the new mutants have similar problems, that could plausibly explain some of their excessive social interactions in the new study. "[The mutants] might just find the new mouse interesting, over and over again," he says.
To investigate the downstream effects of losing PSD-95, Holmes' team analyzed the expression of more than 8,000 genes in the forebrain of the mutant animals. The researchers found abnormal expression of ten genes related to synaptic function: three genes expressed at higher levels, and seven — including, most notably, CYLN2 in the Williams syndrome region — at lower levels.
"I would be hesitant to say this is a model of Williams syndrome, but there's definitely something interesting going on," Holmes says. "The fact that this gene is down-regulated and that these animals show these behaviors — it must be telling us something about the neurobiology of that disease."
Other experts say it's difficult to tie the findings to Williams syndrome because little is known about when and where the 25 deleted genes are normally expressed in the brain. "Having low levels of CYLN2 in a certain part of forebrain in these mice could mean nothing at all, or it could be really interesting — we just don't know, " notes Lucy Osborne, associate professor of medicine and molecular genetics at the University of Toronto.
Still, the idea that DLG4 somehow affects Williams syndrome genes is bolstered by brain imaging experiments conducted by the team.
Holmes collaborated with brain imaging expert Andreas Meyer-Lindenberg to scan the brains of healthy people carrying certain common variants of DLG4 as they looked at threatening faces.
Individuals carrying one particular variant show two signatures associated with Williams syndrome: low connectivity between the amygdala and the anterior cingulate cortex — a middle region important for regulating empathy and emotion — and low volume of a region near the intraparietal sulcus, a fissure that's involved in eye movements and visual attention.
Because the imaging was done on healthy participants, Holmes says, "It really begs the question: could mutations in PSD-95 produce certain personality traits related to hypersociability and affability?"
Although this human link is "intriguing," Osborne says, it's difficult to make comparisons between a common, non-harmful variant of DLG4 and a mutant mouse that's lacking the gene entirely. To probe the link further, she suggests, researchers could observe the behaviors of mutant mice that are missing only one copy of the gene.
Feyder M. et al. Am. J. Psychiatry Epub ahead of print (2010) PubMed
Migaud M. et al. Nature 396, 433-439 (1998) PubMed
You can add a comment by filling out the form below. Plain text formatting.