Kingdom of Heaven trades in timely issues about religion, war, and hostility between the Christian and Muslim worlds, yet Ridley Scott's Crusades-set chronicle—missing the signature skirmishes that gave his overrated Gladiator its visceral edge—contains little astute commentary about contemporary global and regional politics. Charting the journey of a blacksmith named Balian (Orlando Bloom) who, having lost his wife and child, assumes his fallen father's place in Jerusalem as a leading proponent of peace and tolerance, Scott's film, like so much of his work, offers visual pizzazz at the expense of storytelling profundity. Marvelously recreating his 12th-century setting but failing to produce any synergy between his glossy images and gritty tale of redemption, Scott winds up with a handsome but hollow spectacle of speechifying and swordfighting that misguidedly, and ineffectively, relies on its miscast lead and exposition-filled script to generate epic import.
Tormented by the death of his baby and his spouse's subsequent suicide (which puts her on a direct course for Hell), Balian—according to one of the film's numerous corrupt priests—has been abandoned by God. Yet the tradesman is shown the path to absolution by his long-lost father Godfrey of Ibelin (Liam Neeson, once again assuming the role of ass-kicking mentor), a famed Crusader in Jerusalem who wants his French son to join him in the holy city. Under the leadership of benevolent, leprosy-inflicted King Baldwin IV (Edward Norton, hidden beneath a genteel metal mask), 1184 Jerusalem clings to a tenuous peace, and now welcomes Christians, Jews, and Muslims to worship at its hallowed landmarks. Unrest, however, is being fomented by Guy de Lusignan (Marton Csokas), the husband of King Baldwin's sister Sibylla (Eva Green) who, along with a spiteful war-monger (Brendan Gleeson), wants to attack the nearby army of Muslim King Saladin (Ghassan Massoud) and, as a result, bring about a battle that will once and for all solidify control of the city in the hands of Christ's followers. Meanwhile, Balian endeavors to assume his father's quest to transform Jerusalem into the titular "kingdom of heaven," a melting pot where altruism and selflessness will rule, and where all races and faiths will happily coexist in harmony with God.
Scott and screenwriter William Monahan's plot is at once a rather straightforward salvation story as well as a parable about the dangers of organized religion and conflicts waged in its name. On both counts, however, Kingdom of Heaven is leaden and simplistic. With regards to Balian, Bloom is too slight and fresh-faced to be a charismatic leader of thousands, and his boyish prettiness interferes with his attempts to convey the burden of his hero's grief. The actor's performance, as unpersuasive as it may be, is largely sabotaged by the film's conception of the character. Balian is a godless man searching to rediscover his faith (and, with it, deliverance from his misery), yet Monahan's script gives him no character arc, no development—after meeting his father in the film's first 10 minutes, Balian is transformed into a man convinced that a righteous Jerusalem is a liberal Jerusalem, and thus he's static and unchanging, a blandly noble man doing noble things for a noble cause. When the humanistic Balian's triumph finally arrives, it's a moment of neither catharsis nor enlightenment but, rather, one of predictability.
Such a limp narrative center isn't aided by the film's stabs at allegorical relevance. With its cardboard cutout villains (Csokas and Gleason couldn't behave more wretchedly if they tried), underdeveloped, excessively noble Muslim characters (whose equally fanatical desire for a Muslims-only Jerusalem is disingenuously downplayed) and its rosy idealism, Kingdom of Heaven's agreeable condemnation of church-sponsored military campaigns is sapped of any pragmatic relevance. There's nothing inherently wrong with the film's promotion of racial and ethnic unity, or with its characterization of the Crusades as being motivated by dreams of religious, cultural, and economic domination rather than by reverence for the divine. Yet by offering little more than a "can't we all just get along" solution to Middle East discord, the distinctly anti-Church (if not anti-God) film—already overly reliant on typical Hollywood period piece tropes (clearly demarcated good and evil characters, a second-act crisis followed by a victorious finale, hokey Christian and Muslim choral singing)—chooses to merely fall back on naïvely romantic solutions to its central dilemmas.
A sumptuous treat for the eyes, Scott's swiftly paced film—more grand in scope than last summer's matinee idol-overloaded Troy—utilizes stunning set design (by Sonja Klaus) and majestic cinematography (courtesy of John Mathieson) to depict the dusty deserts, opulent throne rooms, and swarming battlefields of medieval Jerusalem. Especially during the enormous action sequences—which, though lacking spatial coherence, express the bloody chaos of hand-to-hand combat—and early scenes in a forest filled with floating ash (reminiscent of Legend's enchanted woods), Scott's vigorous frame has a classical regality. Frustratingly, though, there's no symbiotic relationship between his gorgeous cinematography and the film's themes concerning virtue, sacrifice, and piety. Though Scott shoots in sunny light during happy times and dark blues when a character is depressed (such as an embarrassing scene on the Mount where Balian, via ridiculously unnecessary narration, expresses thoughts like, "God, what is it you want of me?"), his lustrous but skin-deep camera work rarely reflects, amplifies, or comments on the story's bedrock topics and emotions. Never completely dull but disappointingly superficial, Kingdom of Heaven ultimately turns out to be a film about holiness beset by a pedestrian spirit.
Director(s): Ridley Scott Screenwriter(s): William Monahan Cast: Orlando Bloom, Liam Neeson, Jeremy Irons, David Thewlis, Brendan Gleeson, Edward Norton, Eva Green, Marton Csokas, Ghassan Massoud Distributor: 20th Century Fox Runtime: 144 min Rating: R Year: 2005