TAMPA — Myriam Escobar began getting annual mammograms when she was 41.
Watching her mother go through a breast cancer diagnosis and treatment got Escobar to schedule the screening. But her sister-in-law, Patricia Tobon, reacted quite differently.
Tobon found a lump and ignored it. "She didn't tell anybody," remembers Escobar, who had been friends with her since childhood. "She didn't pay any attention to it for a long time. She thought it was nothing."
Tobon died at age 50, leaving behind two teenage sons.
"That is what motivates me to do my job," said Escobar, a community outreach worker at Moffitt Cancer Center. "I don't want other women to lose the battle against breast cancer just because they don't know what to do about it."
Escobar is part of a team at Moffitt that conducts breast cancer education programs for Hispanic women. The program, Yo Me Cuido ("I Take Care of Myself''), recently won praise from the White House, where Escobar was invited to accept an award.
Along with senior community outreach worker Jeannette Palencia, Escobar makes presentations in Spanish in homes, workplaces, churches, beauty salons, libraries, wherever they are invited. Their message is simple: Early detection saves lives.
One of the biggest challenges they face is changing the thinking of women who put everyone else in the family first.
"When we meet with groups we teach them, if you want to take care of your family, you must take care of yourself first so you can be healthy and be there for them," Palencia said.
Since 2011, Yo Me Cuido has reached more than 2,000 women in 10 counties.
But advocates know that much more needs to be done.
Groups like the American Cancer Society and Komen for the Cure have worked for years to increase breast cancer awareness. Especially in October, pink ribbons adorn everything from billboards and buses to NFL uniforms.
But there are still women who seem unaware of what they can do to prevent cancer or detect it early. The problem is particularly deadly for minority women.
Hispanic women historically have lower rates of breast cancer than do white, black and other minority women, according to the American Cancer Society. But breast cancer is still the leading cause of cancer death in Hispanic women, possibly because it is detected at a more advanced stage.
And while breast cancer rates among African-American women are lower than among white women, black women are 41 percent more likely to die of the disease. Lack of early detection may be contributing to this disparity, many experts think.
"That's why mammography screening is still so important for women in minority groups," said B. Lee Green, vice president for diversity at Moffitt Cancer Center and a senior member of the Health Outcomes and Behavior Program.
"What's happening with black women, in particular, is they are getting seen later, when the cancer is in a later stage, when the chances of survival tend to go down. That's why it's critically important to get them in for mammograms and to get them diagnosed early."
Women of all backgrounds are generally much more aware of mammography than they are of genetic testing for cancer risk. But again, the disparity is even greater among minorities.
"There's lots of room for improvement there," said Susan Vadaparampil, a researcher, behavioral scientist and associate member in the Health Outcomes and Behavior Program at Moffitt.
Black women are at increased risk for early-onset breast cancer — disease that strikes before age 50. "That's a big red flag that there might be something genetic going on and they may need to begin mammography screening earlier in life," said Vadaparampil. "Yet African-American and Hispanic women are less likely to know genetic testing is available and they're less likely to be referred for genetic testing by their health care providers."
Minority women are less likely than white women to participate in clinical trials, adding to the knowledge gap. Vadaparampil is involved in a statewide study recruiting black women 50 and younger who were diagnosed with invasive breast cancer between 2009 and 2012. As part of the study, they are offered genetic counseling and testing for BRCA1 and BRCA2 gene mutations.
"We want to learn about the impact of genetic counseling and testing in a group we traditionally don't know a whole lot about," said Vadaparampil, adding that 400 women already are in the study and 200 more are needed.
Carol Tim of St. Petersburg is part of a group that's working hard to improve African-American women's access to breast cancer detection and treatment. Tim, 52, is a two-time breast cancer survivor with a sister who also had the disease. She is active in the faith-based, nonprofit group Sistahs Surviving Breast Cancer. Members support one another, hold educational events, and speak to minority women's groups about the importance of mammograms, early detection, and genetic testing and counseling.
"I knew testing was available to me because I have insurance through work," she said. "But I know a lot of women who don't have insurance and don't know it's something they can do."
Tim was tested a few years ago at the suggestion of her Moffitt physician. "Because with me having breast cancer, my sister having it and because I have a daughter, I just needed to be proactive and find out if there is a gene so (my daughter) doesn't have to go through what we've gone through," she said.
One way that all women can protect themselves and their families, Green said, is to talk about relatives who have had cancer at reunions and other get-togethers.
"We have to have those conversations so we can share information with each other and with our (health care) providers,'' Green said. "Then they can make the best recommendations about screening, prevention and genetic testing."
Irene Maher can be reached at imaher@tampabay.com.