Back in August, Miriam Posner’s post “What are some challenges to doing DH in the library?” initiated a wide-ranging conversation in the blogosphere examining the relationship between DH and libraries. As the dh+lib blog gets a’rolling, it seems useful both to revisit Miriam’s post, but also remind ourselves of the potential DH holds to enable new modes of discovery, knowledge, and interpretation, both for those in the academy and those in the broader field of cultural heritage.
Mir.
What galvanizes many of us working in cultural heritage is how DH tools and practices will enable us to move beyond the traditional methodologies of description of, and access to, archival or cultural collections. These traditional practices, holdovers from a world of physical materials and all the attendant requirements of arrangement, bulk, and storage, have also been fundamentally subjective. Catalogs, finding aids, LCSH — all are products of interpretive biases. That inherent subjectivity engendered a minor, if ongoing, crisis of conscience once contemporary criticism called into question the façade of objectivity in the management of cultural and historical materials (see, for instance, in archival studies, the work of Terry Cook, Heather MacNeil, and David Bearman). But tools like topic modeling, text mining, data visualization, and other methods of distant reading have the power to obviate (or at least largely reduce) the interpretive imposition of the cultural heritage professional at the point of access. They will allow collection stewards to refocus their efforts on providing the tools necessary for users to interpret and understand materials instead of focusing on the descriptions and classifications that group or arrange them.
Because of this, when discussing topic modeling and its promise for cultural heritage at the workshop, I was less fretful of the fallibility of the algorithmic presumptions of Latent Dirichlet allocation and more interested in what I’ll call DH’s confrontational potential — something similar to Mark Sample’s declaration of “an insurgent humanities.” Trevor Owens, in his cogent post about the tweets from #dhtopic, captured something of this seeming divide, noting the assumed disjunction between the exploratory and the evidentiary and how DH dialogues often run on two parallel tracks, one focusing on the freewheeling use of DH tools for discovery and the other on the use of DH tools to validate a specific argument. Here, the “generative discovery” possible with computational tools (akin to Stephen Ramsay’s “The Hermeneutics of Screwing Around“) is merely prologue to the overall process of building an evidence-based defense “against alternative explanations.”.