Tending a garden and dividend investing have some things in common, including the need for high quality and patience.
Want a dividend-yielding portfolio? Glean lessons from gardening
For better yield, choose the best seeds and the right places to plant
Patience can be helpful with a dividend portfolio, but regular pruning is also needed
Long-term dividend investors and gardeners have a lot in common: they’re each seeking to reap a harvest from a carefully tended set of assets.
First off, just like gardeners, investors seeking dividend yield need to locate fertile land that can hopefully produce a bountiful crop. What’s the investment version of a sunny meadow with plenty of sun and access to water? Companies whose dividends have grown annually for the last several decades typically come from noncyclical sectors such as Consumer Staples, Utilities, and Health Care. Sectors that are more cyclical, such as information technology, may have a harder time producing consistent dividend growth because of their competitive and ever-changing nature. (That said, some tech companies have recently been paying higher dividends.)
Timing is another issue gardeners and dividend investors may need to keep in mind. Just as there are certain seasons more conducive to planting a garden, there can be better times to consider investing for dividend yield. Although trying to time the market can be a risky proposition and caution is always warranted, there may be "seasons" in the economic cycle when investors seeking a high-dividend yield have a better chance.
When the economy works through a rough patch, dividend yields often start to look more tempting. That’s because dividend-yielding stocks often, though not always, tend to perform better in a slower economic environment. Back in 2016, U.S. 10-year Treasury note yields fell to historic lows down near 1.4% as interest rates stayed near zero and growth around the world slowed. At that point, the average S&P 500 dividend yield of more than 2% began to look attractive to many investors, although they might have had to pay higher prices for the staples, utilities, and health care stocks with the highest dividends.
On the other hand, in mid-2018 when 10-year note yields climbed above 3%, dividend-yielding stocks might have appeared a little less attractive. Investors could buy a 10-year note and get a yield about 100 basis points higher than they’d get from the average S&P 500 stock. Plus, Treasury notes are generally considered a safer investment than stocks, although no investment is ever truly “safe.”
After picking the proper spot, deciding on the right time to plant, and tilling the fertile land, gardeners must select high-quality seeds. To give their dividend portfolio the best chance to grow, investors should try to think long term. Rather than selecting “flavor of the day” individual stocks, consider choosing those with proven business success. This means doing some research to find out which companies have managed to regularly grow their business and pay dividends not just for years, but for decades. In other words, just as gardeners may want grade A blueberries, dividend investors may want grade A blue chips.
Once the high-quality seeds are planted, then comes the hard part: patiently awaiting growth. Patience is an essential trait for investors. Holding an asset for six months isn’t necessarily a long-term investment. Warren Buffett once said: “If you aren’t willing to own a stock for 10 years, don’t even think about owning it for 10 minutes.” A 10-year holding period may not be right for every individual, but it illustrates that you’re buying a minority stake in an actual operating business that opens its doors every morning whether stock market sentiment is bullish or bearish. If you’ve selected a successful business, that means it typically earns more money than it spends. And those profits are the direct source of dividend payments.
Once the investment starts to show signs of growth, maintenance is essential. For investors who may view their stock as the tree and the dividends as its fruit, it doesn’t make sense to cut down the tree to access the apples. Likewise, most long-term investors aren’t looking for excuses to sell their stock, because if they do, they won’t be able to enjoy the possible dividend growth that the stock could continue to provide in future years. A solid dividend stock can continue spinning off regular yield.
But that doesn’t mean you turn a blind eye to your investment and simply hope for the best. Any good gardener will tell you that clearing out the dead wood is critical for future growth. If an investment isn’t living up to your expectations and the original prospect of dividend growth has turned into a reality of dividend reduction, then that investment may not be fulfilling its purpose. It may need to be “pruned” out of your portfolio.
In recent years, some historically high-dividend-yield stocks started to shrivel in the hot market sun. Some companies once considered benchmarks for regular payouts reduced their dividends or eliminated them altogether. Other companies faced bankruptcy or went out of business.
A plant that was healthy last summer might get eaten by a beetle next year, and stocks, too, go through periods of health and illness. That’s why it can be important to stay on top of maintenance and pruning, whether it’s in the garden in your backyard or the dividend stocks in your brokerage account.
Payment of stock dividends is not guaranteed and dividends may be discontinued. The underlying common stock is subject to market and business risks including insolven.
Content related to Mr. Warren Buffett is provided for informational and/or entertainment purposes only and is not an indication of endorsement, sponsorship, approval, or affiliation. TD Ameritrade, Inc. is not affiliated with Mr. Warren Buffett. The views and opinions expressed in third-party content are solely those of the third party..