BusinessWeek Investor: Economic Indicators
Unveiling the Secrets of the CPI
The first in a series on market-moving numbers
To the uninitiated, the words and acronyms make as much sense as the lyrics to the 1963 song Louie, Louie. Seasonal adjustment. Fixed-weight price deflator. GDP, CPI, NAPM. Yet the ingredients of this alphabet soup play a critical role in financial market volatility. To help readers become better investors, we are starting an occasional series of stories that explain the major pieces of economic data that can roil stock and bond markets. This week, we look at the CPI--short for consumer price index.
When the Bureau of Labor Statistics (BLS) reported on May 14 that the consumer price index jumped a sharp 0.7% in April, it underscored the importance of low inflation to financial markets. Worries over rising inflation sent the Dow Jones industrial average tumbling 194 points and pushed long-term Treasury bond yields to a 12-month high of 5.92%. It was the unexpected jump in the April CPI that began the anticipation of a Federal Reserve rate hike on June 30.UNEXPECTED JUMP. For the markets, the problem is not high inflation per se, but unexpectedly high inflation, says Nomura Securities Chief Economist David Resler. "High unexpected inflation is a wealth transfer from lenders to borrowers," he says, because the money paid back to lenders buys less and less over time. In addition, inflation determines long-term interest rates, which are embedded in future earnings expectations. Guess wrong on inflation, and you might overpay for a stock.
The government tracks inflation in various forms (table). For instance, the producer price index (PPI) captures changes in prices charged by U.S. goods producers. But it ignores inflation among most service companies. The employment cost index (ECI) totals up what businesses pay in wages, salaries, and benefits. For the best inflation reading, however, markets look to the CPI. It is the most comprehensive indicator because it covers all goods and services purchased by households. It's the timeliest because the report is released not quarterly, as is the ECI, but about two weeks after the end of each month. The CPI does include sales and excise taxes. But tax-related price hikes are less of a concern, since they reflect government action, not price pressures in the economy.
The CPI is not perfect. The elderly complain that the CPI, although used for adjusting Social Security checks, misses price hikes on drugs. Increases in property taxes show up only indirectly when the BLS calculates rents. And if your employer increases your health-insurance premium, the CPI won't reflect it.
The BLS counters that the consumer price index's aim is to measure prices for a specific basket of goods and services that the average household buys, according to surveys done from 1993 to 1995. This set basket leads to the biggest rap on the CPI: It does not allow for substitution. Say, a drought in Washington means a price jump for Red Delicious apples. Consumers might buy cheaper Granny Smiths. But the CPI would still give more weight to the price of Red Delicious apples.FOOD PRICES. When you watch the CPI, you should focus, as economists do, on the core rate, which excludes volatile food and energy prices. Doing so gives you the best evidence of how prices are responding to economic activity. Swings in food prices often say more about the weather conditions in the Farm Belt, while oil prices track shifts in OPEC policy. In fact, the 0.4% rise in the April core CPI rattled the markets as much as the 0.7% spike in the index overall.
In the mid-1990s, economists criticized the CPI for overestimating inflation. Even Fed Chairman Alan Greenspan viewed it as flawed. For one thing, said economists, the BLS took too long to include new products, and thus the CPI failed to capture the price reductions that take place in the first years of a product's lifetime. Cell phones, for instance, were costly to use when they were introduced in the 1980s. But competition brought the connection fees down rapidly. However, the BLS did not include cellular phones in the consumer price index until 1998.
John S. Greenlees, assistant commissioner for consumer prices and price indexes, responds that cellular phones posed a specific problem: They did not fit into any category. Said Greenlees: "They weren't long distance, and they weren't a home furnishing," which is where home phones show up. Greenlees says the BLS is better at adding a new item that supplants an existing one, say, a new car model.DREAM INDEX. Quality adjustment is another problem. How does the BLS account for air bags in cars, which add costs but save lives? This problem is especially acute in medical care. The Boskin Commission, set up in 1996 to examine the consumer price index, highlighted these problems and more.
Kenneth V. Dalton, associate commissioner for prices and living conditions, says the BLS was working hard to fix them even before the Boskin report. Economists applaud the efforts so far. But Dalton would like to intensify efforts to improve the CPI's quality-adjustment process. This wish list, of course, depends on unlimited funds. But the BLS recognizes that its monthly budget can buy only so much. Which, in a way, is one of the lessons of the CPI, as well.By Kathleen MadiganReturn to top