Mozilla is beginning a broader second phase of an experiment to show ads to Firefox users, a move that ultimately could help reduce the organization's reliance on revenue from Google.
The first phase of its program, called directory tiles, gave Mozilla the option to show ads or promoted content in a grid of thumbnail images that appear when a user opens a new browser tab, but it's offered only to new Firefox users. Enhanced tiles, though, are for existing Firefox users. The new feature gives publishers an opportunity to replace a thumbnail users already would see with one that's potentially more engaging, said Darren Herman, Mozilla's vice president of content services.
The program could give Mozilla more breathing room. Its share of desktop browser usage is slipping, and its presence in mobile browsing is miniscule, so Mozilla needs new levers to push its agenda. The sponsored tiles could mean more money for Mozilla and a new way to influence how advertisers use the personal data of those who see and click on ads.
The directory tiles are links Mozilla picks on its own, but the enhanced tiles modify links that the user already would see. Instead of seeing an automatically generated thumbnail image that might represent the site poorly -- a login screen, for example -- an enhanced tile would show imagery that looks and works better.
"We're looking at logos, images, or anything related to that site," Herman said.
Showing ads and promoting sites is a significant departure for Mozilla. Today, the nonprofit organization gets the vast majority of its money from Google when Firefox users send the search engine traffic that results in revenue from search ads. The ads would mean a new, potentially much broader source of revenue, though.
Money for Mozilla
"We do see it as an opportunity for us to recognize the value we're bringing to all constituents in the market," Herman said -- in other words, to get paid for Firefox's influence over what people see. "Directory tiles and enhanced tiles are an opportunity to work with marketers and content owners to help them distribute their content."
More revenue doesn't hurt, but Mozilla has bigger ambitions: it hopes the tiles program will revive its influence in the advertising world. The company has had fraught relations with advertisers in the last two years due to its push for a Do Not Track standard that lets people inform Web publishers and advertisers when they don't want their online behavior tracked. Mozilla hopes its tiles program ultimately will "make the Internet healthier," Herman said.
"We're showing the world you can get into the advertising ecosystem, building trust, transparency, and user control into those experiences," he said. "Forty-three billion dollars are spent in online ads every year. The opportunity for us is to clean the Web up, to make it healthier...We have to participate. We can't just sit on the sidelines telling people what to do."
Enhanced tiles arriving soon
The new feature should arrive "in the next couple weeks" for users of Mozilla's pre-release beta and Aurora versions, said Johnath Nightingale, Mozilla's vice president of Firefox.
Enhanced tiles aren't a vehicle for publishers to place ads of their own, Herman added.
"We don't necessarily see the new-tab page as being a window shop. We see it as a content distribution platform...We're working through creative specs to say what publishers can and can't do."
To help steer things what it sees as the right direction, Mozilla will offer a discounted rate to those whose advertising agenda matches Mozilla's.
"Partners who are good actors -- respecting Do Not Track and other areas of the Web we believe fits our mission around innovation, opportunity, and trust -- will get a discount," Herman said. "Not only is this a media content opportunity, it's an opportunity for Mozilla to push our mission forward and reward our partners that are like-minded."
Early directory tiles results
The directory tiles experiment, which is now still limited to people using Mozilla's pre-release versions of Firefox, has shown promise in its early days, according to Nightingale. He said that users are clicking the tiles and sometimes pinning them so they remain a fixture in the browser interface.
Examples of what tiles Mozilla shows include mainstream consumer sites like Facebook and YouTube; non-profit organizations such as Wikipedia; and Mozilla's own sites like Webmaker.
"People are interacting with this much more than with blank white tiles. Some [tiles] have a 5- to 6-percent click-through rate," meaning that five or six out of every hundred users click the directory tiles, Nightingale said. But other sites are only a fraction of a percent, he said.
And Mozilla will keep measuring to make sure the program is a good idea for all Firefox users.
"We're going to do this or not [based on] whether it's valuable to users," Nightingale said.